"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddAlertsTableAction = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _open_config_editor = require("../components/open_config_editor");
var _constants = require("../constants");
var _translations = require("../translations");
var _get_internal_rule_types_with_cache = require("../utils/get_internal_rule_types_with_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkRuleTypesPermissions = async http => {
  try {
    const ruleTypes = await (0, _get_internal_rule_types_with_cache.getInternalRuleTypesWithCache)(http);
    // If the user can access at least one rule type (with any authorizedConsumer, in any app) then
    // they can create alerts visualizations
    return Boolean(ruleTypes.length);
  } catch (error) {
    return false;
  }
};
const getAddAlertsTableAction = coreServices => {
  const {
    http
  } = coreServices;
  return {
    id: _constants.ADD_ALERTS_TABLE_ACTION_ID,
    grouping: [_public.ADD_PANEL_VISUALIZATION_GROUP],
    getIconType: () => 'bell',
    isCompatible: async ({
      embeddable
    }) => {
      const hasAccessToAnyRuleTypes = await checkRuleTypesPermissions(http);
      return (0, _presentationContainers.apiIsPresentationContainer)(embeddable) && hasAccessToAnyRuleTypes;
    },
    execute: async ({
      embeddable
    }) => {
      if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) throw new _public2.IncompatibleActionError();
      const tableConfig = await (0, _open_config_editor.openConfigEditor)({
        coreServices,
        parentApi: embeddable
      });
      await embeddable.addNewPanel({
        panelType: _constants.EMBEDDABLE_ALERTS_TABLE_ID,
        serializedState: {
          rawState: {
            tableConfig
          }
        }
      }, true);
    },
    getDisplayName: () => _translations.ADD_ALERTS_TABLE_ACTION_LABEL
  };
};
exports.getAddAlertsTableAction = getAddAlertsTableAction;