"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reportAttackDiscoveryGenerationSuccess = exports.reportAttackDiscoveryGenerationFailure = void 0;
var _moment = _interopRequireDefault(require("moment/moment"));
var _fp = require("lodash/fp");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _event_based_telemetry = require("../../../lib/telemetry/event_based_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reportAttackDiscoveryGenerationSuccess = ({
  alertsContextCount,
  apiConfig,
  attackDiscoveries,
  durationMs,
  end,
  hasFilter,
  scheduleInfo,
  size,
  start,
  telemetry
}) => {
  var _uniq$length, _attackDiscoveries$le;
  const {
    dateRangeDuration,
    isDefaultDateRange
  } = getTimeRangeDuration({
    start,
    end
  });
  telemetry.reportEvent(_event_based_telemetry.ATTACK_DISCOVERY_SUCCESS_EVENT.eventType, {
    actionTypeId: apiConfig.actionTypeId,
    alertsContextCount,
    alertsCount: (_uniq$length = (0, _fp.uniq)(attackDiscoveries === null || attackDiscoveries === void 0 ? void 0 : attackDiscoveries.flatMap(attackDiscovery => attackDiscovery.alertIds)).length) !== null && _uniq$length !== void 0 ? _uniq$length : 0,
    configuredAlertsCount: size,
    dateRangeDuration,
    discoveriesGenerated: (_attackDiscoveries$le = attackDiscoveries === null || attackDiscoveries === void 0 ? void 0 : attackDiscoveries.length) !== null && _attackDiscoveries$le !== void 0 ? _attackDiscoveries$le : 0,
    durationMs,
    hasFilter,
    isDefaultDateRange,
    model: apiConfig.model,
    provider: apiConfig.provider,
    scheduleInfo
  });
};
exports.reportAttackDiscoveryGenerationSuccess = reportAttackDiscoveryGenerationSuccess;
const reportAttackDiscoveryGenerationFailure = ({
  apiConfig,
  errorMessage,
  scheduleInfo,
  telemetry
}) => {
  telemetry.reportEvent(_event_based_telemetry.ATTACK_DISCOVERY_ERROR_EVENT.eventType, {
    actionTypeId: apiConfig.actionTypeId,
    errorMessage,
    model: apiConfig.model,
    provider: apiConfig.provider,
    scheduleInfo
  });
};
exports.reportAttackDiscoveryGenerationFailure = reportAttackDiscoveryGenerationFailure;
const getTimeRangeDuration = ({
  start,
  end
}) => {
  if (start && end) {
    const forceNow = (0, _moment.default)().toDate();
    const dateStart = _datemath.default.parse(start, {
      roundUp: false,
      momentInstance: _moment.default,
      forceNow
    });
    const dateEnd = _datemath.default.parse(end, {
      roundUp: false,
      momentInstance: _moment.default,
      forceNow
    });
    if (dateStart && dateEnd) {
      const dateRangeDuration = _moment.default.duration(dateEnd.diff(dateStart)).asHours();
      return {
        dateRangeDuration,
        isDefaultDateRange: end === 'now' && start === 'now-24h'
      };
    }
  }
  return {
    // start and/or end undefined, return 0 hours
    dateRangeDuration: 0,
    isDefaultDateRange: false
  };
};