"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GENERATE_CHAT_TITLE_PROMPT = void 0;
exports.generateChatTitle = generateChatTitle;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("@langchain/core/prompts");
var _helpers = require("../../../../../routes/helpers");
var _event_based_telemetry = require("../../../../telemetry/event_based_telemetry");
var _prompt = require("../../../../prompt");
var _constants = require("../constants");
var _local_prompt_object = require("../../../../prompt/local_prompt_object");
var _utils = require("../../../../../routes/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERATE_CHAT_TITLE_PROMPT = ({
  prompt,
  responseLanguage
}) => _prompts.ChatPromptTemplate.fromMessages([['system', `${prompt}\nPlease create the title in ${responseLanguage}.`], ['human', '{input}']]);
exports.GENERATE_CHAT_TITLE_PROMPT = GENERATE_CHAT_TITLE_PROMPT;
async function generateChatTitle({
  actionsClient,
  conversationsDataClient,
  logger,
  savedObjectsClient,
  state,
  model,
  telemetryParams,
  telemetry
}) {
  if (!state.conversationId) {
    return;
  }
  try {
    var _conversation$title, _state$responseLangua;
    logger.debug(() => `${_constants.NodeType.GENERATE_CHAT_TITLE}: Node state:\n${JSON.stringify(state, null, 2)}`);
    const conversation = await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.getConversation({
      id: state.conversationId
    }));
    if (!conversation) {
      logger.debug('No conversation found, skipping chat title generation');
      return;
    }
    if (conversation !== null && conversation !== void 0 && (_conversation$title = conversation.title) !== null && _conversation$title !== void 0 && _conversation$title.length && (conversation === null || conversation === void 0 ? void 0 : conversation.title) !== _helpers.NEW_CHAT) {
      return;
    }
    const outputParser = new _output_parsers.StringOutputParser();
    const prompt = await (0, _prompt.getPrompt)({
      actionsClient,
      connectorId: state.connectorId,
      promptId: _prompt.promptDictionary.chatTitle,
      promptGroupId: _local_prompt_object.promptGroupId.aiAssistant,
      provider: state.llmType,
      savedObjectsClient
    });
    const graph = GENERATE_CHAT_TITLE_PROMPT({
      prompt,
      responseLanguage: (_state$responseLangua = state.responseLanguage) !== null && _state$responseLangua !== void 0 ? _state$responseLangua : 'English'
    }).pipe(model).pipe(outputParser).withConfig({
      runName: 'Generate Chat Title'
    });
    const chatTitle = await graph.invoke({
      input: JSON.stringify(state.input, null, 2)
    });
    logger.debug(`chatTitle: ${chatTitle}`);
    if ((conversation === null || conversation === void 0 ? void 0 : conversation.title) !== chatTitle) {
      await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.updateConversation({
        conversationUpdateProps: {
          id: state.conversationId,
          title: chatTitle
        }
      }));
    }
  } catch (e) {
    var _telemetryParams$acti, _state$llmType, _e$message, _ref, _telemetryParams$assi, _telemetryParams$isEn, _ref2, _e$name;
    telemetry.reportEvent(_event_based_telemetry.INVOKE_ASSISTANT_ERROR_EVENT.eventType, {
      actionTypeId: (_telemetryParams$acti = telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.actionTypeId) !== null && _telemetryParams$acti !== void 0 ? _telemetryParams$acti : (0, _utils.getActionTypeId)((_state$llmType = state.llmType) !== null && _state$llmType !== void 0 ? _state$llmType : `.gen-ai`),
      model: telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.model,
      errorMessage: (_e$message = e.message) !== null && _e$message !== void 0 ? _e$message : e.toString(),
      assistantStreamingEnabled: (_ref = (_telemetryParams$assi = telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.assistantStreamingEnabled) !== null && _telemetryParams$assi !== void 0 ? _telemetryParams$assi : state.isStream) !== null && _ref !== void 0 ? _ref : true,
      isEnabledKnowledgeBase: (_telemetryParams$isEn = telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.isEnabledKnowledgeBase) !== null && _telemetryParams$isEn !== void 0 ? _telemetryParams$isEn : false,
      errorLocation: 'generateChatTitle'
    });
    await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.updateConversation({
      conversationUpdateProps: {
        id: state.conversationId,
        title: ((_ref2 = (_e$name = e.name) !== null && _e$name !== void 0 ? _e$name : e.message) !== null && _ref2 !== void 0 ? _ref2 : e.toString()).slice(0, 60)
      }
    }));
  }
}