"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefendInsight = void 0;
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefendInsight = async ({
  esClient,
  logger,
  index,
  id,
  user
}) => {
  const filterByUser = [{
    nested: {
      path: 'users',
      query: {
        bool: {
          must: [{
            match: user.profile_uid ? {
              'users.id': user.profile_uid
            } : {
              'users.name': user.username
            }
          }]
        }
      }
    }
  }];
  try {
    var _insights$;
    const response = await esClient.search({
      query: {
        bool: {
          must: [{
            bool: {
              should: [{
                term: {
                  _id: id
                }
              }]
            }
          }, ...filterByUser]
        }
      },
      _source: true,
      ignore_unavailable: true,
      index,
      seq_no_primary_term: true
    });
    const insights = (0, _helpers.transformESSearchToDefendInsights)(response);
    return (_insights$ = insights[0]) !== null && _insights$ !== void 0 ? _insights$ : null;
  } catch (err) {
    logger.error(`Error fetching Defend insight: ${err} with id: ${id}`);
    throw err;
  }
};
exports.getDefendInsight = getDefendInsight;