"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentReferenceComponentFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _knowledge_base_entry_reference = require("./knowledge_base_entry_reference");
var _security_alert_reference = require("./security_alert_reference");
var _security_alerts_page_reference = require("./security_alerts_page_reference");
var _content_reference_button = require("./content_reference_button");
var _product_documentation_reference = require("./product_documentation_reference");
var _esql_query_reference = require("./esql_query_reference");
var _href_reference = require("./href_reference");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** While a message is being streamed, content references are null. When a message has finished streaming, content references are either defined or undefined */

const ContentReferenceComponentFactory = ({
  contentReferencesVisible,
  contentReferenceNode
}) => {
  if (!contentReferencesVisible) return null;
  if (contentReferenceNode.contentReferenceCount === undefined) return null;
  if (contentReferenceNode.contentReference === undefined) {
    return /*#__PURE__*/_react.default.createElement(_content_reference_button.ContentReferenceButton, {
      disabled: true,
      contentReferenceCount: contentReferenceNode.contentReferenceCount
    });
  }
  switch (contentReferenceNode.contentReference.type) {
    case 'KnowledgeBaseEntry':
      {
        return /*#__PURE__*/_react.default.createElement(_knowledge_base_entry_reference.KnowledgeBaseEntryReference, {
          contentReferenceNode: contentReferenceNode
        });
      }
    case 'SecurityAlert':
      return /*#__PURE__*/_react.default.createElement(_security_alert_reference.SecurityAlertReference, {
        contentReferenceNode: contentReferenceNode
      });
    case 'SecurityAlertsPage':
      return /*#__PURE__*/_react.default.createElement(_security_alerts_page_reference.SecurityAlertsPageReference, {
        contentReferenceNode: contentReferenceNode
      });
    case 'ProductDocumentation':
      return /*#__PURE__*/_react.default.createElement(_product_documentation_reference.ProductDocumentationReference, {
        contentReferenceNode: contentReferenceNode
      });
    case 'EsqlQuery':
      {
        return /*#__PURE__*/_react.default.createElement(_esql_query_reference.EsqlQueryReference, {
          contentReferenceNode: contentReferenceNode
        });
      }
    case 'Href':
      {
        return /*#__PURE__*/_react.default.createElement(_href_reference.HrefReference, {
          contentReferenceNode: contentReferenceNode
        });
      }
    default:
      const _exhaustiveCheck = contentReferenceNode.contentReference;
      throw new Error(`Unhandled case: ${_exhaustiveCheck}`);
  }
};
exports.ContentReferenceComponentFactory = ContentReferenceComponentFactory;