"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMarkdownWithOriginalValues = exports.getMarkdownFields = exports.getAttackDiscoveryMarkdownFields = exports.getAttackDiscoveryMarkdown = exports.getAttackChainMarkdown = void 0;
var _attack_discovery_helpers = require("../attack_discovery_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMarkdownFields = markdown => {
  const regex = new RegExp('{{\\s*(\\S+)\\s+(.*?)\\s*}}', 'gm');
  return markdown.replace(regex, (_, field, value) => `\`${value}\``);
};
exports.getMarkdownFields = getMarkdownFields;
const getAttackChainMarkdown = attackDiscovery => {
  const tacticMetadata = (0, _attack_discovery_helpers.getTacticMetadata)(attackDiscovery).filter(tactic => tactic.detected);
  if (tacticMetadata.length === 0) {
    return '';
  }
  const markdownList = tacticMetadata.map(tactic => `- ${(0, _attack_discovery_helpers.getTacticLabel)(tactic.name)}`).join('\n');
  return `### Attack Chain
${markdownList}
`;
};
exports.getAttackChainMarkdown = getAttackChainMarkdown;
const getMarkdownWithOriginalValues = ({
  markdown,
  replacements
}) => {
  if (replacements == null) {
    return markdown;
  }
  return Object.keys(replacements).reduce((acc, uuid) => acc.replaceAll(uuid, replacements[uuid]), markdown);
};
exports.getMarkdownWithOriginalValues = getMarkdownWithOriginalValues;
const getAttackDiscoveryMarkdown = ({
  attackDiscovery,
  replacements
}) => {
  var _attackDiscovery$enti;
  const title = getMarkdownFields(attackDiscovery.title);
  const entitySummaryMarkdown = getMarkdownFields((_attackDiscovery$enti = attackDiscovery.entitySummaryMarkdown) !== null && _attackDiscovery$enti !== void 0 ? _attackDiscovery$enti : '');
  const summaryMarkdown = getMarkdownFields(attackDiscovery.summaryMarkdown);
  const detailsMarkdown = getMarkdownFields(attackDiscovery.detailsMarkdown);
  const markdown = `## ${title}

${entitySummaryMarkdown}

### Summary
${summaryMarkdown}

### Details
${detailsMarkdown}

${getAttackChainMarkdown(attackDiscovery)}
`;
  if (replacements != null) {
    return getMarkdownWithOriginalValues({
      markdown,
      replacements
    });
  } else {
    return markdown;
  }
};
exports.getAttackDiscoveryMarkdown = getAttackDiscoveryMarkdown;
const getAttackDiscoveryMarkdownFields = ({
  attackDiscovery,
  replacements
}) => {
  var _attackDiscovery$enti2;
  const title = getMarkdownFields(attackDiscovery.title);
  const entitySummaryMarkdown = getMarkdownFields((_attackDiscovery$enti2 = attackDiscovery.entitySummaryMarkdown) !== null && _attackDiscovery$enti2 !== void 0 ? _attackDiscovery$enti2 : '');
  const summaryMarkdown = getMarkdownFields(attackDiscovery.summaryMarkdown);
  const detailsMarkdown = getMarkdownFields(attackDiscovery.detailsMarkdown);
  if (replacements != null) {
    return {
      detailsMarkdown: getMarkdownWithOriginalValues({
        markdown: detailsMarkdown,
        replacements
      }),
      entitySummaryMarkdown: getMarkdownWithOriginalValues({
        markdown: entitySummaryMarkdown,
        replacements
      }),
      title: getMarkdownWithOriginalValues({
        markdown: title,
        replacements
      }),
      summaryMarkdown: getMarkdownWithOriginalValues({
        markdown: summaryMarkdown,
        replacements
      })
    };
  } else {
    return {
      detailsMarkdown,
      entitySummaryMarkdown,
      title,
      summaryMarkdown
    };
  }
};
exports.getAttackDiscoveryMarkdownFields = getAttackDiscoveryMarkdownFields;