"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _history = require("history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class HistoryService {
  constructor() {
    (0, _defineProperty2.default)(this, "history", void 0);
  }
  /**
   * Makes sure discover and context are using one instance of history.
   */
  getHistory() {
    if (!this.history) {
      this.history = (0, _history.createHashHistory)();
      this.history.listen(() => {
        // keep at least one listener so that `history.location` always in sync
      });
    }
    return this.history;
  }

  /**
   * Discover currently uses two `history` instances: one from Kibana Platform and
   * another from `history` package. Below function is used every time Discover
   * app is loaded to synchronize both instances.
   *
   * This helper is temporary until https://github.com/elastic/kibana/issues/65161 is resolved.
   */
  syncHistoryLocations() {
    const history = this.getHistory();
    Object.assign(history.location, (0, _history.createHashHistory)().location);
    return history;
  }
}
exports.HistoryService = HistoryService;