"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsEsqlMode = void 0;
var _data_sources = require("../../../../common/data_sources");
var _discover_app_state_container = require("../state_management/discover_app_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useIsEsqlMode = () => {
  const dataSource = (0, _discover_app_state_container.useAppStateSelector)(state => state.dataSource);
  return (0, _data_sources.isDataSourceType)(dataSource, _data_sources.DataSourceType.Esql);
};
exports.useIsEsqlMode = useIsEsqlMode;