"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _unsavedChangesBadge = require("@kbn/unsaved-changes-badge");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _on_save_search = require("./on_save_search");
var _solutions_view_badge = require("./solutions_view_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper function to build the top nav badges
 */
const getTopNavBadges = ({
  hasUnsavedChanges,
  isMobile,
  stateContainer,
  services,
  topNavCustomization
}) => {
  var _defaultBadges$unsave;
  const saveSearch = initialCopyOnSave => (0, _on_save_search.onSaveSearch)({
    initialCopyOnSave,
    savedSearch: stateContainer.savedSearchState.getState(),
    services,
    state: stateContainer
  });
  const defaultBadges = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : topNavCustomization.defaultBadges;
  const entries = [];
  const isManaged = stateContainer.savedSearchState.getState().managed;
  if (services.spaces && !isMobile) {
    entries.push({
      badgeText: _i18n.i18n.translate('discover.topNav.solutionViewTitle', {
        defaultMessage: 'Check out context-aware Discover'
      }),
      renderCustomBadge: ({
        badgeText
      }) => /*#__PURE__*/_react.default.createElement(_solutions_view_badge.SolutionsViewBadge, {
        badgeText: badgeText
      })
    });
  }
  if (hasUnsavedChanges && !(defaultBadges !== null && defaultBadges !== void 0 && (_defaultBadges$unsave = defaultBadges.unsavedChangesBadge) !== null && _defaultBadges$unsave !== void 0 && _defaultBadges$unsave.disabled)) {
    entries.push((0, _unsavedChangesBadge.getTopNavUnsavedChangesBadge)({
      onRevert: async () => {
        (0, _discoverUtils.dismissFlyouts)([_discoverUtils.DiscoverFlyouts.lensEdit]);
        await stateContainer.actions.undoSavedSearchChanges();
      },
      onSave: services.capabilities.discover.save && !isManaged ? async () => {
        await saveSearch();
      } : undefined,
      onSaveAs: services.capabilities.discover.save ? async () => {
        await saveSearch(true);
      } : undefined
    }));
  }
  if (isManaged) {
    entries.push((0, _managedContentBadge.getManagedContentBadge)(_i18n.i18n.translate('discover.topNav.managedContentLabel', {
      defaultMessage: 'This Discover session is managed by Elastic. Changes here must be saved to a new Discover session.'
    })));
  }
  return entries;
};
exports.getTopNavBadges = getTopNavBadges;