"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onResize = exports.DiscoverDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _cellActions = require("@kbn/cell-actions");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _discoverUtils = require("@kbn/discover-utils");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _unifiedFieldList = require("@kbn/unified-field-list");
var _discover_grid = require("../../../../components/discover_grid");
var _constants = require("../../../../../common/constants");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _doc_table_infinite = require("../../../../components/doc_table/doc_table_infinite");
var _document_explorer_callout = require("../document_explorer_callout");
var _get_allowed_sample_size = require("../../../../utils/get_allowed_sample_size");
var _discover_grid_flyout = require("../../../../components/discover_grid_flyout");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _use_fetch_more_records = require("./use_fetch_more_records");
var _selected_vs_available_callout = require("./selected_vs_available_callout");
var _customizations = require("../../../../customizations");
var _on_resize_grid_column = require("../../../../utils/on_resize_grid_column");
var _grid_customisations = require("../../hooks/grid_customisations");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _use_additional_field_groups = require("../../hooks/sidebar/use_additional_field_groups");
var _context_awareness = require("../../../../context_awareness");
var _redux = require("../../state_management/redux");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const containerStyles = (0, _react2.css)`
  position: relative;
`;
const progressStyle = (0, _react2.css)`
  z-index: 2;
`;
const DocTableInfiniteMemoized = /*#__PURE__*/_react.default.memo(_doc_table_infinite.DocTableInfinite);
const DiscoverGridMemoized = /*#__PURE__*/_react.default.memo(_discover_grid.DiscoverGrid);

// export needs for testing
const onResize = (colSettings, stateContainer) => {
  const state = stateContainer.appState.getState();
  const newGrid = (0, _on_resize_grid_column.onResizeGridColumn)(colSettings, state.grid);
  stateContainer.appState.update({
    grid: newGrid
  });
};
exports.onResize = onResize;
function DiscoverDocumentsComponent({
  viewModeToggle,
  dataView,
  onAddFilter,
  stateContainer,
  onFieldEdited
}) {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const documents$ = stateContainer.dataState.data$.documents$;
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const {
    dataViews,
    capabilities,
    uiSettings,
    uiActions,
    ebtManager,
    fieldsMetadata
  } = services;
  const requestParams = (0, _redux.useInternalStateSelector)(state => state.dataRequestParams);
  const [dataSource, query, sort, rowHeight, headerRowHeight, rowsPerPage, grid, columns, sampleSizeState, density] = (0, _discover_app_state_container.useAppStateSelector)(state => {
    return [state.dataSource, state.query, state.sort, state.rowHeight, state.headerRowHeight, state.rowsPerPage, state.grid, state.columns, state.sampleSize, state.density];
  });
  const expandedDoc = (0, _redux.useInternalStateSelector)(state => state.expandedDoc);
  const initialDocViewerTabId = (0, _redux.useInternalStateSelector)(state => state.initialDocViewerTabId);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const useNewFieldsApi = (0, _react.useMemo)(() => !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE), [uiSettings]);
  const hideAnnouncements = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.HIDE_ANNOUNCEMENTS), [uiSettings]);
  const isLegacy = (0, _react.useMemo)(() => (0, _discoverUtils.isLegacyTableEnabled)({
    uiSettings,
    isEsqlMode
  }), [uiSettings, isEsqlMode]);
  const documentState = (0, _use_data_state.useDataState)(documents$);
  const isDataLoading = documentState.fetchStatus === _types.FetchStatus.LOADING || documentState.fetchStatus === _types.FetchStatus.PARTIAL;

  // This is needed to prevent EuiDataGrid pushing onSort because the data view has been switched.
  // It's just necessary for non ES|QL requests since they don't have a partial result state, that's
  // considered as loading state in the Component.
  // 1. When switching the data view, the sorting in the URL is reset to the default sorting of the selected data view.
  // 2. The new sort param is already available in this component and propagated to the EuiDataGrid.
  // 3. currentColumns are still referring to the old state
  // 4. since the new sort by field isn't available in currentColumns EuiDataGrid is emitting a 'onSort', which is unsorting the grid
  // 5. this is propagated to Discover's URL and causes an unwanted change of state to an unsorted state
  // This solution switches to the loading state in this component when the URL index doesn't match the dataView.id
  const isDataViewLoading = (0, _redux.useInternalStateSelector)(state => state.isDataViewLoading) && !isEsqlMode;
  const isEmptyDataResult = isEsqlMode || !documentState.result || documentState.result.length === 0;
  const rows = (0, _react.useMemo)(() => documentState.result || [], [documentState.result]);
  const {
    isMoreDataLoading,
    totalHits,
    onFetchMoreRecords
  } = (0, _use_fetch_more_records.useFetchMoreRecords)({
    stateContainer
  });
  const setAppState = (0, _react.useCallback)(({
    settings,
    ...rest
  }) => {
    stateContainer.appState.update({
      ...rest,
      grid: settings
    });
  }, [stateContainer]);
  const {
    columns: currentColumns,
    onAddColumn,
    onRemoveColumn,
    onMoveColumn,
    onSetColumns
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState,
    useNewFieldsApi,
    columns,
    sort,
    settings: grid
  });
  const onAddColumnWithTracking = (0, _react.useCallback)(columnName => {
    onAddColumn(columnName);
    void ebtManager.trackDataTableSelection({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onAddColumn, ebtManager, fieldsMetadata]);
  const onRemoveColumnWithTracking = (0, _react.useCallback)(columnName => {
    onRemoveColumn(columnName);
    void ebtManager.trackDataTableRemoval({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onRemoveColumn, ebtManager, fieldsMetadata]);
  const docViewerRef = (0, _react.useRef)(null);
  const setExpandedDoc = (0, _react.useCallback)((doc, options) => {
    dispatch(_redux.internalStateActions.setExpandedDoc({
      expandedDoc: doc,
      initialDocViewerTabId: options === null || options === void 0 ? void 0 : options.initialTabId
    }));
    if (options !== null && options !== void 0 && options.initialTabId) {
      var _docViewerRef$current;
      (_docViewerRef$current = docViewerRef.current) === null || _docViewerRef$current === void 0 ? void 0 : _docViewerRef$current.setSelectedTabId(options.initialTabId);
    }
  }, [dispatch]);
  const onResizeDataGrid = (0, _react.useCallback)(colSettings => onResize(colSettings, stateContainer), [stateContainer]);
  const onUpdateRowsPerPage = (0, _react.useCallback)(nextRowsPerPage => {
    stateContainer.appState.update({
      rowsPerPage: nextRowsPerPage
    });
  }, [stateContainer]);
  const onUpdateSampleSize = (0, _react.useCallback)(newSampleSize => {
    stateContainer.appState.update({
      sampleSize: newSampleSize
    });
  }, [stateContainer]);
  const onSort = (0, _react.useCallback)(nextSort => {
    stateContainer.appState.update({
      sort: nextSort
    });
  }, [stateContainer]);
  const onUpdateRowHeight = (0, _react.useCallback)(newRowHeight => {
    stateContainer.appState.update({
      rowHeight: newRowHeight
    });
  }, [stateContainer]);
  const onUpdateHeaderRowHeight = (0, _react.useCallback)(newHeaderRowHeight => {
    stateContainer.appState.update({
      headerRowHeight: newHeaderRowHeight
    });
  }, [stateContainer]);
  const onUpdateDensity = (0, _react.useCallback)(newDensity => {
    stateContainer.appState.update({
      density: newDensity
    });
  }, [stateContainer]);

  // should be aligned with embeddable `showTimeCol` prop
  const showTimeCol = (0, _react.useMemo)(() => !uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false), [uiSettings]);
  const columnsMeta = (0, _react.useMemo)(() => documentState.esqlQueryColumns ? (0, _unifiedDataTable.getTextBasedColumnsMeta)(documentState.esqlQueryColumns) : undefined, [documentState.esqlQueryColumns]);
  const {
    filters
  } = (0, _unifiedFieldList.useQuerySubscriber)({
    data: services.data
  });
  const cellActionsMetadata = (0, _context_awareness.useAdditionalCellActions)({
    dataSource,
    dataView,
    query,
    filters,
    timeRange: requestParams.timeRangeAbsolute
  });
  const renderDocumentView = (0, _react.useCallback)((hit, displayedRows, displayedColumns, customColumnsMeta) => /*#__PURE__*/_react.default.createElement(_discover_grid_flyout.DiscoverGridFlyout, {
    dataView: dataView,
    hit: hit,
    hits: displayedRows
    // if default columns are used, dont make them part of the URL - the context state handling will take care to restore them
    ,
    columns: displayedColumns,
    columnsMeta: customColumnsMeta,
    savedSearchId: savedSearch.id,
    onFilter: onAddFilter,
    onRemoveColumn: onRemoveColumnWithTracking,
    onAddColumn: onAddColumnWithTracking,
    onClose: () => setExpandedDoc(undefined),
    setExpandedDoc: setExpandedDoc,
    query: query,
    initialTabId: initialDocViewerTabId,
    docViewerRef: docViewerRef
  }), [dataView, savedSearch.id, onAddFilter, onRemoveColumnWithTracking, onAddColumnWithTracking, setExpandedDoc, query, initialDocViewerTabId]);
  const configRowHeight = uiSettings.get(_discoverUtils.ROW_HEIGHT_OPTION);
  const cellRendererParams = (0, _react.useMemo)(() => ({
    actions: {
      addFilter: onAddFilter
    },
    dataView,
    density: density !== null && density !== void 0 ? density : (0, _unifiedDataTable.getDataGridDensity)(services.storage, 'discover'),
    rowHeight: (0, _unifiedDataTable.getRowHeight)({
      storage: services.storage,
      consumer: 'discover',
      rowHeightState: rowHeight,
      configRowHeight
    })
  }), [onAddFilter, dataView, density, services.storage, rowHeight, configRowHeight]);
  const {
    rowAdditionalLeadingControls
  } = (0, _customizations.useDiscoverCustomization)('data_table') || {};
  const {
    customCellRenderer,
    customGridColumnsConfiguration
  } = (0, _grid_customisations.useContextualGridCustomisations)(cellRendererParams) || {};
  const additionalFieldGroups = (0, _use_additional_field_groups.useAdditionalFieldGroups)();
  const getCellRenderersAccessor = (0, _context_awareness.useProfileAccessor)('getCellRenderers');
  const cellRenderers = (0, _react.useMemo)(() => {
    const getCellRenderers = getCellRenderersAccessor(() => customCellRenderer !== null && customCellRenderer !== void 0 ? customCellRenderer : {});
    return getCellRenderers(cellRendererParams);
  }, [cellRendererParams, customCellRenderer, getCellRenderersAccessor]);
  const documents = (0, _useObservable.default)(stateContainer.dataState.data$.documents$);
  const callouts = (0, _react.useMemo)(() => {
    var _documentState$interc;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_selected_vs_available_callout.SelectedVSAvailableCallout, {
      esqlQueryColumns: documents === null || documents === void 0 ? void 0 : documents.esqlQueryColumns
      // `discover:searchFieldsFromSource` adds `_source` to the columns, but we should exclude it from the callout
      ,
      selectedColumns: currentColumns.filter(col => col !== '_source')
    }), /*#__PURE__*/_react.default.createElement(_searchResponseWarnings.SearchResponseWarningsCallout, {
      warnings: (_documentState$interc = documentState.interceptedWarnings) !== null && _documentState$interc !== void 0 ? _documentState$interc : []
    }));
  }, [currentColumns, documents === null || documents === void 0 ? void 0 : documents.esqlQueryColumns, documentState.interceptedWarnings]);
  const loadingIndicator = (0, _react.useMemo)(() => isDataLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "discoverDataGridUpdating",
    size: "xs",
    color: "accent",
    position: "absolute",
    css: progressStyle
  }) : null, [isDataLoading]);
  const renderCustomToolbarWithElements = (0, _react.useMemo)(() => (0, _unifiedDataTable.getRenderCustomToolbarWithElements)({
    leftSide: viewModeToggle,
    bottomSection: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, callouts, loadingIndicator)
  }), [viewModeToggle, callouts, loadingIndicator]);
  if (isDataViewLoading || isEmptyDataResult && isDataLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "dscDocuments__loading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.loadingDocuments",
      defaultMessage: "Loading documents"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, viewModeToggle), callouts), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "dscTable",
    "aria-labelledby": "documentsAriaLabel",
    css: containerStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "documentsAriaLabel"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.documentsAriaLabel",
    defaultMessage: "Documents"
  }))), isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rows && rows.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideAnnouncements && /*#__PURE__*/_react.default.createElement(_document_explorer_callout.DocumentExplorerCallout, null), /*#__PURE__*/_react.default.createElement(DocTableInfiniteMemoized, {
    columns: currentColumns,
    dataView: dataView,
    rows: rows,
    sort: sort || [],
    isLoading: isDataLoading,
    searchDescription: savedSearch.description,
    sharedItemTitle: savedSearch.title,
    isEsqlMode: isEsqlMode,
    onAddColumn: onAddColumn,
    onFilter: onAddFilter,
    onMoveColumn: onMoveColumn,
    onRemoveColumn: onRemoveColumn,
    onSort: !isEsqlMode ? onSort : undefined,
    useNewFieldsApi: useNewFieldsApi,
    dataTestSubj: "discoverDocTable"
  })), loadingIndicator), !isLegacy && /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTable"
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions
  }, /*#__PURE__*/_react.default.createElement(DiscoverGridMemoized, {
    ariaLabelledBy: "documentsAriaLabel",
    columns: currentColumns,
    columnsMeta: columnsMeta,
    expandedDoc: expandedDoc,
    dataView: dataView,
    loadingState: isDataLoading ? _unifiedDataTable.DataLoadingState.loading : isMoreDataLoading ? _unifiedDataTable.DataLoadingState.loadingMore : _unifiedDataTable.DataLoadingState.loaded,
    rows: rows,
    sort: sort || [],
    searchDescription: savedSearch.description,
    searchTitle: savedSearch.title,
    setExpandedDoc: setExpandedDoc,
    showTimeCol: showTimeCol,
    settings: grid,
    onFilter: onAddFilter,
    onSetColumns: onSetColumns,
    onSort: onSort,
    onResize: onResizeDataGrid,
    useNewFieldsApi: useNewFieldsApi,
    configHeaderRowHeight: 3,
    headerRowHeightState: headerRowHeight,
    onUpdateHeaderRowHeight: onUpdateHeaderRowHeight,
    rowHeightState: rowHeight,
    onUpdateRowHeight: onUpdateRowHeight,
    isSortEnabled: true,
    isPlainRecord: isEsqlMode,
    isPaginationEnabled: !isEsqlMode,
    rowsPerPageState: rowsPerPage !== null && rowsPerPage !== void 0 ? rowsPerPage : (0, _constants.getDefaultRowsPerPage)(services.uiSettings),
    onUpdateRowsPerPage: onUpdateRowsPerPage,
    maxAllowedSampleSize: (0, _get_allowed_sample_size.getMaxAllowedSampleSize)(services.uiSettings),
    sampleSizeState: (0, _get_allowed_sample_size.getAllowedSampleSize)(sampleSizeState, services.uiSettings),
    onUpdateSampleSize: !isEsqlMode ? onUpdateSampleSize : undefined,
    onFieldEdited: onFieldEdited,
    configRowHeight: configRowHeight,
    showMultiFields: uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    maxDocFieldsDisplayed: uiSettings.get(_discoverUtils.MAX_DOC_FIELDS_DISPLAYED),
    renderDocumentView: renderDocumentView,
    renderCustomToolbar: renderCustomToolbarWithElements,
    services: services,
    totalHits: totalHits,
    onFetchMoreRecords: onFetchMoreRecords,
    externalCustomRenderers: cellRenderers,
    customGridColumnsConfiguration: customGridColumnsConfiguration,
    rowAdditionalLeadingControls: rowAdditionalLeadingControls,
    additionalFieldGroups: additionalFieldGroups,
    dataGridDensityState: density,
    onUpdateDataGridDensity: onUpdateDensity,
    onUpdateESQLQuery: stateContainer.actions.updateESQLQuery,
    query: query,
    cellActionsTriggerId: _context_awareness.DISCOVER_CELL_ACTIONS_TRIGGER.id,
    cellActionsMetadata: cellActionsMetadata,
    cellActionsHandling: "append"
  })))));
}
const DiscoverDocuments = exports.DiscoverDocuments = /*#__PURE__*/(0, _react.memo)(DiscoverDocumentsComponent);