"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appLocatorGetLocationCommon = void 0;
var _esQuery = require("@kbn/es-query");
var _data_sources = require("./data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const appLocatorGetLocationCommon = async ({
  useHash: useHashOriginal,
  setStateToKbnUrl
}, ...[params]) => {
  const {
    useHash = useHashOriginal,
    filters,
    dataViewId,
    indexPatternId,
    dataViewSpec,
    query,
    refreshInterval,
    savedSearchId,
    timeRange,
    searchSessionId,
    columns,
    grid,
    savedQuery,
    sort,
    interval,
    viewMode,
    hideAggregatedPreview,
    breakdownField,
    isAlertResults
  } = params;
  const savedSearchPath = savedSearchId ? `view/${encodeURIComponent(savedSearchId)}` : '';
  const appState = {};
  const queryState = {};
  if (query) appState.query = query;
  if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !(0, _esQuery.isFilterPinned)(f));
  if (indexPatternId) appState.dataSource = (0, _data_sources.createDataViewDataSource)({
    dataViewId: indexPatternId
  });
  if (dataViewId) appState.dataSource = (0, _data_sources.createDataViewDataSource)({
    dataViewId
  });
  if ((0, _esQuery.isOfAggregateQueryType)(query)) appState.dataSource = (0, _data_sources.createEsqlDataSource)();
  if (columns) appState.columns = columns;
  if (grid) appState.grid = grid;
  if (savedQuery) appState.savedQuery = savedQuery;
  if (sort) appState.sort = sort;
  if (interval) appState.interval = interval;
  if (timeRange) queryState.time = timeRange;
  if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => (0, _esQuery.isFilterPinned)(f));
  if (refreshInterval) queryState.refreshInterval = refreshInterval;
  if (viewMode) appState.viewMode = viewMode;
  if (hideAggregatedPreview) appState.hideAggregatedPreview = hideAggregatedPreview;
  if (breakdownField) appState.breakdownField = breakdownField;
  const state = {};
  if (dataViewSpec) state.dataViewSpec = dataViewSpec;
  if (isAlertResults) state.isAlertResults = isAlertResults;
  let path = `#/${savedSearchPath}`;
  if (searchSessionId) {
    path = `${path}?searchSessionId=${searchSessionId}`;
  }
  if (Object.keys(queryState).length) {
    path = setStateToKbnUrl('_g', queryState, {
      useHash
    }, path);
  }
  if (Object.keys(appState).length) {
    path = setStateToKbnUrl('_a', appState, {
      useHash
    }, path);
  }
  return {
    app: 'discover',
    path,
    state
  };
};
exports.appLocatorGetLocationCommon = appLocatorGetLocationCommon;