"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPublicStateFromContext = exports.getContextFromPublicState = void 0;
var _dataset_quality_details_controller = require("../../state_machines/dataset_quality_details_controller");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPublicStateFromContext = context => {
  return {
    dataStream: context.dataStream,
    qualityIssues: context.qualityIssues,
    failedDocsErrors: context.failedDocsErrors,
    timeRange: context.timeRange,
    breakdownField: context.breakdownField,
    qualityIssuesChart: context.qualityIssuesChart,
    integration: context.integration,
    expandedQualityIssue: context.expandedQualityIssue,
    showCurrentQualityIssues: context.showCurrentQualityIssues
  };
};
exports.getPublicStateFromContext = getPublicStateFromContext;
const getContextFromPublicState = publicState => {
  var _publicState$qualityI, _publicState$qualityI2, _publicState$qualityI3, _publicState$timeRang, _publicState$qualityI4, _publicState$showCurr;
  return {
    ..._dataset_quality_details_controller.DEFAULT_CONTEXT,
    qualityIssues: {
      table: {
        ..._dataset_quality_details_controller.DEFAULT_CONTEXT.qualityIssues.table,
        ...((_publicState$qualityI = publicState.qualityIssues) === null || _publicState$qualityI === void 0 ? void 0 : _publicState$qualityI.table),
        sort: (_publicState$qualityI2 = publicState.qualityIssues) !== null && _publicState$qualityI2 !== void 0 && (_publicState$qualityI3 = _publicState$qualityI2.table) !== null && _publicState$qualityI3 !== void 0 && _publicState$qualityI3.sort ? {
          ...publicState.qualityIssues.table.sort,
          field: publicState.qualityIssues.table.sort.field
        } : _dataset_quality_details_controller.DEFAULT_CONTEXT.qualityIssues.table.sort
      }
    },
    timeRange: {
      ..._dataset_quality_details_controller.DEFAULT_CONTEXT.timeRange,
      ...publicState.timeRange,
      refresh: {
        ..._dataset_quality_details_controller.DEFAULT_CONTEXT.timeRange.refresh,
        ...((_publicState$timeRang = publicState.timeRange) === null || _publicState$timeRang === void 0 ? void 0 : _publicState$timeRang.refresh)
      }
    },
    dataStream: publicState.dataStream,
    breakdownField: publicState.breakdownField,
    qualityIssuesChart: (_publicState$qualityI4 = publicState.qualityIssuesChart) !== null && _publicState$qualityI4 !== void 0 ? _publicState$qualityI4 : _dataset_quality_details_controller.DEFAULT_CONTEXT.qualityIssuesChart,
    expandedQualityIssue: publicState.expandedQualityIssue,
    showCurrentQualityIssues: (_publicState$showCurr = publicState.showCurrentQualityIssues) !== null && _publicState$showCurr !== void 0 ? _publicState$showCurr : _dataset_quality_details_controller.DEFAULT_CONTEXT.showCurrentQualityIssues
  };
};
exports.getContextFromPublicState = getContextFromPublicState;