"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityStatPercentageLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../../hooks");
var _quality_indicator = require("../../quality_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QualityStatPercentageLink = ({
  isLoading,
  dataStreamStat,
  timeRange,
  dataTestSubj,
  query = {
    language: 'kuery',
    query: ''
  },
  accessor,
  selector,
  fewDocStatsTooltip
}) => {
  const {
    [accessor]: {
      percentage,
      count
    }
  } = dataStreamStat;
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetRedirectLinkTelemetry)({
    rawName: `${dataStreamStat.rawName}${selector !== null && selector !== void 0 ? selector : ''}`,
    query
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat,
    query,
    sendTelemetry,
    timeRangeConfig: timeRange,
    selector
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "50px",
    height: "20px",
    borderRadius: "m",
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, percentage ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": dataTestSubj
  }, redirectLinkProps.linkProps), /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
    percentage: percentage,
    docsCount: count,
    fewDocsTooltipContent: fewDocStatsTooltip
  })) : /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
    percentage: percentage,
    fewDocsTooltipContent: fewDocStatsTooltip
  })));
};
exports.QualityStatPercentageLink = QualityStatPercentageLink;