"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileUploadLiteView = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _fileUpload = require("@kbn/file-upload");
var _file_clash_warning = require("./file_clash_warning");
var _file_picker = require("./file_picker");
var _file_status = require("./file_status");
var _index_input = require("./index_input");
var _overall_upload_status = require("./overall_upload_status");
var _import_errors = require("./import_errors");
var _data_view_illustration = require("./data_view_illustration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileUploadLiteView = ({
  props,
  onClose
}) => {
  const {
    flyoutContent
  } = props;
  const {
    fileUploadManager,
    filesStatus,
    uploadStatus,
    fileClashes,
    fullFileUpload,
    uploadStarted,
    onImportClick,
    canImport,
    setIndexName,
    setIndexValidationStatus,
    deleteFile
  } = (0, _fileUpload.useFileUploadContext)();
  (0, _react.useEffect)(() => {
    return () => {
      fileUploadManager.destroy();
    };
  }, [fileUploadManager]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, flyoutContent !== null && flyoutContent !== void 0 && flyoutContent.title ? flyoutContent.title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.uploadFileTitle",
    defaultMessage: "Upload a file"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, uploadStatus.overallImportStatus === _fileUpload.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, flyoutContent !== null && flyoutContent !== void 0 && flyoutContent.description ? flyoutContent.description : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.uploadFileDescription",
    defaultMessage: "Upload your file, analyze its data, and import the data into an Elasticsearch index. The data can also be automatically vectorized using semantic text."
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.uploadFileDescriptionLink",
    defaultMessage: "If you need to customize the file upload process, the full version is available {fullToolLink}.",
    values: {
      fullToolLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: fullFileUpload
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.uploadView.uploadFileDescriptionLinkText",
        defaultMessage: "here"
      }))
    }
  }), ' '))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_file_picker.FilePicker, {
    fileUploadManager: fileUploadManager
  })) : null, uploadStatus.overallImportStatus === _fileUpload.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filesStatus.map((status, i) => /*#__PURE__*/_react.default.createElement(_file_status.FileStatus, {
    uploadStatus: uploadStatus,
    fileStatus: status,
    key: i,
    deleteFile: () => deleteFile(i),
    index: i,
    showFileContentPreview: flyoutContent === null || flyoutContent === void 0 ? void 0 : flyoutContent.showFileContentPreview,
    showFileSummary: flyoutContent === null || flyoutContent === void 0 ? void 0 : flyoutContent.showFileSummary
  })), fileClashes ? /*#__PURE__*/_react.default.createElement(_file_clash_warning.FileClashWarning, {
    uploadStatus: uploadStatus,
    filesStatus: filesStatus,
    removeClashingFiles: () => fileUploadManager.removeClashingFiles()
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, uploadStatus.overallImportStatus === _fileUpload.STATUS.NOT_STARTED && filesStatus.length > 0 && uploadStatus.analysisStatus !== _fileUpload.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fileUploadManager.isExistingIndexUpload() === false ? /*#__PURE__*/_react.default.createElement(_index_input.IndexInput, {
    setIndexName: setIndexName,
    setIndexValidationStatus: setIndexValidationStatus
  }) : null) : null, uploadStarted ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_data_view_illustration.DataViewIllustration, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_overall_upload_status.OverallUploadStatus, {
    uploadStatus: uploadStatus,
    filesStatus: filesStatus
  }), uploadStatus.overallImportStatus === _fileUpload.STATUS.FAILED ? /*#__PURE__*/_react.default.createElement(_import_errors.ImportErrors, {
    uploadStatus: uploadStatus
  }) : null) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, uploadStatus.overallImportStatus === _fileUpload.STATUS.STARTED ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    disabled: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.importingButton",
    defaultMessage: "Importing"
  })))) : null, uploadStatus.overallImportStatus === _fileUpload.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: canImport === false,
    onClick: onImportClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.importButton",
    defaultMessage: "Import"
  })) : null))));
};
exports.FileUploadLiteView = FileUploadLiteView;