"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _utils = require("../../../utils");
var _metric_distribution_chart = require("../metric_distribution_chart");
var _top_values = require("../../../top_values");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _expanded_row_panel = require("./expanded_row_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRIC_DISTRIBUTION_CHART_WIDTH = 260;
const METRIC_DISTRIBUTION_CHART_HEIGHT = 200;
const NumberContent = ({
  config,
  onAddFilter
}) => {
  var _stats$distribution, _stats$distribution2;
  const {
    stats
  } = config;
  const distributionChartData = (0, _react.useMemo)(() => (0, _metric_distribution_chart.buildChartDataFromStats)(stats === null || stats === void 0 ? void 0 : stats.distribution, METRIC_DISTRIBUTION_CHART_WIDTH), [stats === null || stats === void 0 ? void 0 : stats.distribution]);
  if (stats === undefined) return null;
  const {
    min,
    median,
    max,
    distribution
  } = stats;
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  const summaryTableItems = [{
    function: 'min',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.minLabel",
      defaultMessage: "min"
    }),
    value: (0, _utils.kibanaFieldFormat)(min, fieldFormat)
  }, ...((0, _mlIsDefined.isDefined)(median) ? [{
    function: 'median',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.medianLabel",
      defaultMessage: "median"
    }),
    value: (0, _utils.kibanaFieldFormat)(median, fieldFormat)
  }] : []), {
    function: 'max',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.maxLabel",
      defaultMessage: "max"
    }),
    value: (0, _utils.kibanaFieldFormat)(max, fieldFormat)
  }];
  const summaryTableColumns = [{
    name: '',
    render: summaryItem => summaryItem.display,
    width: '25px',
    align: _eui.LEFT_ALIGNMENT
  }, {
    field: 'value',
    name: '',
    render: v => /*#__PURE__*/_react.default.createElement("strong", null, v),
    align: _eui.RIGHT_ALIGNMENT
  }];
  const summaryTableTitle = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.summaryTableTitle', {
    defaultMessage: 'Summary'
  });
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerNumberContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvSummaryTable__wrapper dvPanel__wrapper',
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, null, summaryTableTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: 'dvSummaryTable',
    compressed: true,
    items: summaryTableItems,
    columns: summaryTableColumns,
    tableCaption: summaryTableTitle,
    "data-test-subj": 'dataVisualizerNumberSummaryTable'
  })), stats && /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: stats,
    fieldFormat: fieldFormat,
    barColor: "success",
    compressed: true,
    onAddFilter: onAddFilter
  }), distribution && ((_stats$distribution = stats.distribution) === null || _stats$distribution === void 0 ? void 0 : _stats$distribution.percentiles.length) !== undefined && ((_stats$distribution2 = stats.distribution) === null || _stats$distribution2 === void 0 ? void 0 : _stats$distribution2.percentiles.length) > 2 && /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: 'dataVisualizerFieldDataMetricDistribution',
    className: "dvPanel__wrapper",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.distributionTitle",
    defaultMessage: "Distribution"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: 'metricDistributionChartContainer'
  }, /*#__PURE__*/_react.default.createElement(_metric_distribution_chart.MetricDistributionChart, {
    width: METRIC_DISTRIBUTION_CHART_WIDTH,
    height: METRIC_DISTRIBUTION_CHART_HEIGHT,
    chartData: distributionChartData,
    fieldFormat: fieldFormat
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: 'center'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.displayingPercentilesLabel",
    defaultMessage: "Displaying {minPercent} - {maxPercent} percentiles",
    values: {
      minPercent: (0, _utils.numberAsOrdinal)(distribution.minPercentile),
      maxPercent: (0, _utils.numberAsOrdinal)(distribution.maxPercentile)
    }
  })))));
};
exports.NumberContent = NumberContent;