"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollupDeprecatedWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const rollupBetaWarningTitle = _i18n.i18n.translate('indexPatternEditor.rollupIndexPattern.deprecationWarning.title', {
  defaultMessage: 'Deprecated in 8.11.0'
});
const RollupDeprecatedWarning = ({
  docLinksService
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: rollupBetaWarningTitle,
  color: "warning",
  iconType: "question",
  "data-test-subj": "rollupDeprecationCallout"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.rollupDataView.deprecationWarning.textParagraphOne",
  defaultMessage: "Rollups are deprecated and will be removed in a future version. {downsamplingLink} can be used as an alternative.",
  values: {
    downsamplingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinksService.links.elasticsearch.rollupMigratingToDownsampling,
      target: "_blank",
      "data-test-subj": "downsamplingLink"
    }, _i18n.i18n.translate('indexPatternEditor.rollupDataView.deprecationWarning.downsamplingLink', {
      defaultMessage: 'Downsampling'
    }))
  }
}));
exports.RollupDeprecatedWarning = RollupDeprecatedWarning;