"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.areRefreshIntervalsDifferent = areRefreshIntervalsDifferent;
exports.areTimeRangesDifferent = areTimeRangesDifferent;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const valueOf = function (o) {
  if (o) return o.valueOf();
};
function areRefreshIntervalsDifferent(rangeA, rangeB) {
  if (_lodash.default.isObject(rangeA) && _lodash.default.isObject(rangeB)) {
    if (valueOf(rangeA.value) !== valueOf(rangeB.value) || valueOf(rangeA.pause) !== valueOf(rangeB.pause)) {
      return true;
    }
  } else {
    return !_lodash.default.isEqual(rangeA, rangeB);
  }
  return false;
}
function areTimeRangesDifferent(rangeA, rangeB) {
  if (rangeA && rangeB && _lodash.default.isObject(rangeA) && _lodash.default.isObject(rangeB)) {
    if (valueOf(rangeA.to) !== valueOf(rangeB.to) || valueOf(rangeA.from) !== valueOf(rangeB.from)) {
      return true;
    }
  } else {
    return !_lodash.default.isEqual(rangeA, rangeB);
  }
  return false;
}