"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSectionAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => Boolean((0, _presentationContainers.apiCanAddNewSection)(api));
class AddSectionAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_ADD_SECTION);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_ADD_SECTION);
    (0, _defineProperty2.default)(this, "order", 40);
    (0, _defineProperty2.default)(this, "grouping", [_public.ADD_PANEL_ANNOTATION_GROUP]);
  }
  getDisplayName() {
    return _i18n.i18n.translate('dashboard.collapsibleSection.displayName', {
      defaultMessage: 'Collapsible section'
    });
  }
  getIconType() {
    return 'section';
  }
  async isCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable);
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    embeddable.addNewSection();
  }
}
exports.AddSectionAction = AddSectionAction;