"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternPageTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation_links = require("../services/documentation_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutoFollowPatternPageTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  bottomBorder: true,
  pageTitle: /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "pageTitle"
  }, title),
  rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: _documentation_links.documentationLinks.apis.createAutoFollowPattern,
    target: "_blank",
    iconType: "question",
    "data-test-subj": "docsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.readDocsAutoFollowPatternButtonLabel",
    defaultMessage: "Auto-follow pattern docs"
  }))]
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
exports.AutoFollowPatternPageTitle = AutoFollowPatternPageTitle;
AutoFollowPatternPageTitle.propTypes = {
  title: _propTypes.default.node.isRequired
};