"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nextActionMap = exports.next = void 0;
var Actions = _interopRequireWildcard(require("./actions"));
var _utils = require("../common/utils");
var _utils2 = require("./utils");
var _build_pickup_mappings_query = require("../core/build_pickup_mappings_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The response type of the provided control state's action.
 *
 * E.g. given 'INIT', provides the response type of the action triggered by
 * `next` in the 'INIT' control state.
 */

const nextActionMap = context => {
  const client = context.elasticsearchClient;
  return {
    INIT: state => Actions.fetchIndices({
      client,
      indices: [`${context.indexPrefix}_*`]
    }),
    CREATE_TARGET_INDEX: state => Actions.createIndex({
      client,
      indexName: state.currentIndex,
      aliases: state.creationAliases,
      mappings: state.indexMappings,
      esCapabilities: context.esCapabilities
    }),
    UPDATE_INDEX_MAPPINGS: state => Actions.updateAndPickupMappings({
      client,
      index: state.currentIndex,
      mappings: {
        properties: state.additiveMappingChanges
      },
      batchSize: context.batchSize,
      query: (0, _build_pickup_mappings_query.buildPickupMappingsQuery)(Object.keys(state.additiveMappingChanges))
    }),
    UPDATE_INDEX_MAPPINGS_WAIT_FOR_TASK: state => Actions.waitForPickupUpdatedMappingsTask({
      client,
      taskId: state.updateTargetMappingsTaskId,
      timeout: '60s'
    }),
    UPDATE_MAPPING_MODEL_VERSIONS: state => Actions.updateIndexMeta({
      client,
      index: state.currentIndex,
      meta: (0, _utils2.setMetaMappingMigrationComplete)({
        meta: state.currentIndexMeta,
        versions: context.typeVirtualVersions
      })
    }),
    UPDATE_ALIASES: state => Actions.updateAliases({
      client,
      aliasActions: state.aliasActions
    }),
    INDEX_STATE_UPDATE_DONE: state => () => Actions.noop(),
    DOCUMENTS_UPDATE_INIT: state => () => Actions.noop(),
    SET_DOC_MIGRATION_STARTED: state => Actions.updateIndexMeta({
      client,
      index: state.currentIndex,
      meta: (0, _utils2.setMetaDocMigrationStarted)({
        meta: state.currentIndexMeta
      })
    }),
    SET_DOC_MIGRATION_STARTED_WAIT_FOR_INSTANCES: state => Actions.waitForDelay({
      delayInSec: context.migrationConfig.zdt.metaPickupSyncDelaySec
    }),
    CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS: state => Actions.cleanupUnknownAndExcluded({
      client,
      indexName: state.currentIndex,
      discardUnknownDocs: true,
      excludeOnUpgradeQuery: state.excludeOnUpgradeQuery,
      excludeFromUpgradeFilterHooks: state.excludeFromUpgradeFilterHooks,
      knownTypes: context.types,
      removedTypes: context.deletedTypes
    }),
    CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_WAIT_FOR_TASK: state => Actions.waitForDeleteByQueryTask({
      client,
      taskId: state.deleteTaskId,
      timeout: '120s'
    }),
    CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_REFRESH: state => Actions.refreshIndex({
      client,
      index: state.currentIndex
    }),
    OUTDATED_DOCUMENTS_SEARCH_OPEN_PIT: state => Actions.openPit({
      client,
      index: state.currentIndex
    }),
    OUTDATED_DOCUMENTS_SEARCH_READ: state => Actions.readWithPit({
      client,
      pitId: state.pitId,
      searchAfter: state.lastHitSortValue,
      batchSize: context.migrationConfig.batchSize,
      query: state.outdatedDocumentsQuery,
      seqNoPrimaryTerm: true
    }),
    OUTDATED_DOCUMENTS_SEARCH_TRANSFORM: state => Actions.transformDocs({
      outdatedDocuments: state.outdatedDocuments,
      transformRawDocs: state.transformRawDocs
    }),
    OUTDATED_DOCUMENTS_SEARCH_BULK_INDEX: state => Actions.bulkOverwriteTransformedDocuments({
      client,
      index: state.currentIndex,
      operations: state.bulkOperationBatches[state.currentBatch],
      refresh: false
    }),
    OUTDATED_DOCUMENTS_SEARCH_CLOSE_PIT: state => Actions.closePit({
      client,
      pitId: state.pitId
    }),
    OUTDATED_DOCUMENTS_SEARCH_REFRESH: state => Actions.refreshIndex({
      client,
      index: state.currentIndex
    }),
    UPDATE_DOCUMENT_MODEL_VERSIONS: state => Actions.updateIndexMeta({
      client,
      index: state.currentIndex,
      meta: (0, _utils2.setMetaDocMigrationComplete)({
        meta: state.currentIndexMeta,
        versions: context.typeVirtualVersions
      })
    }),
    UPDATE_DOCUMENT_MODEL_VERSIONS_WAIT_FOR_INSTANCES: state => Actions.waitForDelay({
      delayInSec: context.migrationConfig.zdt.metaPickupSyncDelaySec
    })
  };
};
exports.nextActionMap = nextActionMap;
const next = context => {
  const map = nextActionMap(context);
  return state => {
    const delay = (0, _utils.createDelayFn)(state);
    if (state.controlState === 'DONE' || state.controlState === 'FATAL') {
      // Return null if we're in one of the terminating states
      return null;
    } else {
      // Otherwise return the delayed action
      // We use an explicit cast as otherwise TS infers `(state: never) => ...`
      // here because state is inferred to be the intersection of all states
      // instead of the union.
      const nextAction = map[state.controlState];
      return delay(nextAction(state));
    }
  };
};
exports.next = next;