"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPresets = getPresets;
var _lodash = require("lodash");
var _defaultNavAnalytics = require("@kbn/default-nav-analytics");
var _defaultNavMl = require("@kbn/default-nav-ml");
var _defaultNavDevtools = require("@kbn/default-nav-devtools");
var _defaultNavManagement = require("@kbn/default-nav-management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getPresets(preset) {
  if (preset === 'all') {
    return {
      analytics: (0, _lodash.cloneDeep)(_defaultNavAnalytics.defaultNavigation),
      devtools: (0, _lodash.cloneDeep)(_defaultNavDevtools.defaultNavigation),
      ml: (0, _lodash.cloneDeep)(_defaultNavMl.defaultNavigation),
      management: (0, _lodash.cloneDeep)(_defaultNavManagement.defaultNavigation)
    };
  }
  switch (preset) {
    case 'analytics':
      return (0, _lodash.cloneDeep)(_defaultNavAnalytics.defaultNavigation);
    case 'devtools':
      return (0, _lodash.cloneDeep)(_defaultNavDevtools.defaultNavigation);
    case 'ml':
      return (0, _lodash.cloneDeep)(_defaultNavMl.defaultNavigation);
    case 'management':
      return (0, _lodash.cloneDeep)(_defaultNavManagement.defaultNavigation);
    default:
      throw new Error(`Unknown preset: ${preset}`);
  }
}