"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMSearch = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function savedObjectToItem(savedObject, allowedSavedObjectAttributes) {
  const {
    id,
    type,
    updated_at: updatedAt,
    created_at: createdAt,
    attributes,
    references,
    error,
    namespaces,
    version,
    managed
  } = savedObject;
  return {
    id,
    type,
    managed,
    updatedAt,
    createdAt,
    attributes: (0, _lodash.pick)(attributes, allowedSavedObjectAttributes),
    references,
    error,
    namespaces,
    version
  };
}
const getMSearch = ({
  savedObjectType,
  cmServicesDefinition,
  allowedSavedObjectAttributes
}) => {
  return {
    savedObjectType,
    toItemResult: (ctx, savedObject) => {
      const transforms = ctx.utils.getTransforms(cmServicesDefinition);

      // Validate DB response and DOWN transform to the request version
      const {
        value,
        error: resultError
      } = transforms.mSearch.out.result.down(
      // Ran into a case where a schema was broken by a SO attribute that wasn't part of the definition
      // so we specify which attributes are allowed
      savedObjectToItem(savedObject, allowedSavedObjectAttributes));
      if (resultError) {
        throw _boom.default.badRequest(`Invalid response. ${resultError.message}`);
      }
      return value;
    }
  };
};
exports.getMSearch = getMSearch;