"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorContextProvider = EditorContextProvider;
exports.useEditorReadContext = exports.useEditorActionContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var editor = _interopRequireWildcard(require("../../stores/editor"));
var _create_use_context = require("../create_use_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EditorReadContext = /*#__PURE__*/(0, _react.createContext)(editor.initialValue);
const EditorActionContext = /*#__PURE__*/(0, _react.createContext)(() => {});
function EditorContextProvider({
  children,
  settings
}) {
  const [state, dispatch] = (0, _react.useReducer)(editor.reducer, editor.initialValue, value => ({
    ...value,
    settings
  }));
  return /*#__PURE__*/_react.default.createElement(EditorReadContext.Provider, {
    value: state
  }, /*#__PURE__*/_react.default.createElement(EditorActionContext.Provider, {
    value: dispatch
  }, children));
}
const useEditorReadContext = exports.useEditorReadContext = (0, _create_use_context.createUseContext)(EditorReadContext, 'EditorReadContext');
const useEditorActionContext = exports.useEditorActionContext = (0, _create_use_context.createUseContext)(EditorActionContext, 'EditorActionContext');