"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavConfig = getTopNavConfig;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getTopNavConfig({
  selectedTab,
  setSelectedTab
}) {
  return [{
    id: _constants.SHELL_TAB_ID,
    label: _i18n.i18n.translate('console.topNav.shellTabLabel', {
      defaultMessage: 'Shell'
    }),
    description: _i18n.i18n.translate('console.topNav.shellTabDescription', {
      defaultMessage: 'Shell'
    }),
    onClick: () => {
      setSelectedTab(_constants.SHELL_TAB_ID);
    },
    testId: 'consoleShellButton',
    isSelected: selectedTab === _constants.SHELL_TAB_ID,
    tourStep: _constants.SHELL_TOUR_STEP
  }, {
    id: _constants.HISTORY_TAB_ID,
    label: _i18n.i18n.translate('console.topNav.historyTabLabel', {
      defaultMessage: 'History'
    }),
    description: _i18n.i18n.translate('console.topNav.historyTabDescription', {
      defaultMessage: 'History'
    }),
    onClick: () => {
      setSelectedTab(_constants.HISTORY_TAB_ID);
    },
    testId: 'consoleHistoryButton',
    isSelected: selectedTab === _constants.HISTORY_TAB_ID,
    tourStep: _constants.HISTORY_TOUR_STEP
  }, {
    id: _constants.CONFIG_TAB_ID,
    label: _i18n.i18n.translate('console.topNav.configTabLabel', {
      defaultMessage: 'Config'
    }),
    description: _i18n.i18n.translate('console.topNav.configTabDescription', {
      defaultMessage: 'Config'
    }),
    onClick: () => {
      setSelectedTab(_constants.CONFIG_TAB_ID);
    },
    testId: 'consoleConfigButton',
    isSelected: selectedTab === _constants.CONFIG_TAB_ID,
    tourStep: _constants.CONFIG_TOUR_STEP
  }];
}