"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityFindingFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _copy_button = require("../../../components/copy_button");
var _take_action = require("../../../components/take_action");
var _helpers = require("../../../../common/utils/helpers");
var _csp_inline_description_list = require("../../../components/csp_inline_description_list");
var _vulnerability_overview_tab = require("./vulnerability_overview_tab");
var _vulnerability_json_tab = require("./vulnerability_json_tab");
var _test_subjects = require("../test_subjects");
var _vulnerability_table_tab = require("./vulnerability_table_tab");
var _create_detection_rule_from_vulnerability = require("../utils/create_detection_rule_from_vulnerability");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewTabId = 'vuln-flyout-overview-tab';
const tableTabId = 'vuln-flyout-table-tab';
const jsonTabId = 'vuln-flyout-json-tab';
const renderFinding = (item, i, field, object) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  direction: "row",
  justifyContent: "flexStart",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  css: (0, _react2.css)`
          white-space: nowrap;
          overflow: hidden;
          text-overflow: ellipsis;
        `
}, item)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_copy_button.CopyButton, {
  copyText: item
})));
const getFlyoutDescriptionList = vulnerabilityRecord => {
  var _vulnerabilityRecord$, _vulnerabilityRecord$2, _vulnerabilityRecord$3, _vulnerabilityRecord$4, _vulnerabilityRecord$5, _vulnerabilityRecord$6, _vulnerabilityRecord$7, _vulnerabilityRecord$8, _vulnerabilityRecord$9, _vulnerabilityRecord$10;
  return [((_vulnerabilityRecord$ = vulnerabilityRecord.resource) === null || _vulnerabilityRecord$ === void 0 ? void 0 : _vulnerabilityRecord$.id) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.resourceId', {
      defaultMessage: 'Resource ID'
    }),
    description: vulnerabilityRecord.resource.id
  }, ((_vulnerabilityRecord$2 = vulnerabilityRecord.resource) === null || _vulnerabilityRecord$2 === void 0 ? void 0 : _vulnerabilityRecord$2.name) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.resourceName', {
      defaultMessage: 'Resource Name'
    }),
    description: vulnerabilityRecord.resource.name
  }, ((_vulnerabilityRecord$3 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$3 === void 0 ? void 0 : _vulnerabilityRecord$3.name) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.packageTitle', {
      defaultMessage: 'Package'
    }),
    description: Array.isArray((_vulnerabilityRecord$4 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$4 === void 0 ? void 0 : _vulnerabilityRecord$4.name) ? /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
            display: inline-block;
          `
    }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
      items: (_vulnerabilityRecord$5 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$5 === void 0 ? void 0 : _vulnerabilityRecord$5.name,
      field: 'package.name',
      object: vulnerabilityRecord,
      renderItem: renderFinding
    })) : (_vulnerabilityRecord$6 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$6 === void 0 ? void 0 : _vulnerabilityRecord$6.name
  }, ((_vulnerabilityRecord$7 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$7 === void 0 ? void 0 : _vulnerabilityRecord$7.version) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.versionTitle', {
      defaultMessage: 'Version'
    }),
    description: Array.isArray((_vulnerabilityRecord$8 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$8 === void 0 ? void 0 : _vulnerabilityRecord$8.version) ? /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
            display: inline-block;
          `
    }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
      items: (_vulnerabilityRecord$9 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$9 === void 0 ? void 0 : _vulnerabilityRecord$9.version,
      field: 'package.version',
      object: vulnerabilityRecord,
      renderItem: renderFinding
    })) : (_vulnerabilityRecord$10 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$10 === void 0 ? void 0 : _vulnerabilityRecord$10.version
  }].filter(_helpers.truthy);
};
const VulnerabilityFindingFlyout = ({
  closeFlyout,
  vulnerabilityRecord,
  onPaginate,
  totalVulnerabilitiesCount,
  flyoutIndex,
  isLoading = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(overviewTabId);
  const vulnerability = vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : vulnerabilityRecord.vulnerability;
  const tabs = (0, _react.useMemo)(() => [{
    id: overviewTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.overviewTabLabel",
      defaultMessage: "Overview"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_overview_tab.VulnerabilityOverviewTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }, {
    id: tableTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.tableTabLabel",
      defaultMessage: "Table"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_table_tab.VulnerabilityTableTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }, {
    id: jsonTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.jsonTabLabel",
      defaultMessage: "JSON"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_json_tab.VulnerabilityJsonTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }], [vulnerabilityRecord]);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = () => tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": (0, _test_subjects.TAB_ID_VULNERABILITY_FLYOUT)(tab.id),
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index
  }, tab.name));
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const LOADING_ARIA_LABEL = _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.loadingAriaLabel', {
    defaultMessage: 'Loading'
  });
  const createVulnerabilityRuleFn = async http => await (0, _create_detection_rule_from_vulnerability.createDetectionRuleFromVulnerabilityFinding)(http, vulnerabilityRecord);
  const renderCveBadge = () => {
    if (Array.isArray(vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id) && (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) > 1) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_CVE_BADGE,
        color: "accent",
        css: (0, _react2.css)`
              border-radius: ${euiTheme.border.radius.small};
            `
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.cveTooltip",
        defaultMessage: "{value} More",
        values: {
          value: (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) - 1
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  };
  const renderCves = () => {
    if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.id) || (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    const renderVulnerabilityId = () => {
      const id = Array.isArray(vulnerability.id) ? vulnerability.id[0] : vulnerability.id;
      const references = Array.isArray(vulnerability.reference) ? vulnerability.reference : [vulnerability.reference];
      const referenceLink = (0, _cloudSecurityPosture.findReferenceLink)(references, id);
      return referenceLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_REFERENCE_LINK,
        color: "primary",
        href: referenceLink,
        target: "_blank",
        style: {
          color: euiTheme.colors.primary,
          display: 'flex',
          alignItems: 'center'
        }
      }, id) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_ID
      }, id);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      css: (0, _react2.css)`
              line-height: 32px;
              font-weight: normal;
            `
    }, renderVulnerabilityId())), renderCveBadge());
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "m",
    isLoading: isLoading,
    contentAriaLabel: LOADING_ARIA_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
              gap: ${euiTheme.size.s};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
    severity: (0, _cloudSecurityPosture.getNormalizedSeverity)(vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.severity)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
                  gap: ${euiTheme.size.s};
                `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    css: (0, _react2.css)``
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": _test_subjects.VULNERABILITY_HEADER_TITLE
  }, vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.title))), renderCves(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                      line-height: 20px;
                      margin-bottom: ${euiTheme.size.m};
                    `
  }, /*#__PURE__*/_react.default.createElement(_csp_inline_description_list.CspInlineDescriptionList, {
    testId: _test_subjects.FINDINGS_VULNERABILITY_FLYOUT_DESCRIPTION_LIST,
    listItems: getFlyoutDescriptionList(vulnerabilityRecord)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "m",
    isLoading: isLoading,
    contentAriaLabel: LOADING_ARIA_LABEL
  }, selectedTabContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: onPaginate ? 'spaceBetween' : 'flexEnd'
  }, onPaginate && totalVulnerabilitiesCount && flyoutIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: totalVulnerabilitiesCount,
    activePage: flyoutIndex,
    onPageClick: onPaginate,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    createRuleFn: createVulnerabilityRuleFn
  })))));
};
exports.VulnerabilityFindingFlyout = VulnerabilityFindingFlyout;