"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelVersion3 = void 0;
var _schemas = require("../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Adds the incremental id to the cases SO.
 */
const modelVersion3 = exports.modelVersion3 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      incremental_id: {
        type: 'unsigned_long'
      }
    }
  }],
  schemas: {
    forwardCompatibility: _schemas.casesSchemaV3.extends({}, {
      unknowns: 'ignore'
    })
  }
};