"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSynchronizationSourceQuery = exports.CAI_CASES_SYNCHRONIZATION_TASK_ID = exports.CAI_CASES_SOURCE_QUERY = exports.CAI_CASES_SOURCE_INDEX = exports.CAI_CASES_INDEX_VERSION = exports.CAI_CASES_INDEX_NAME = exports.CAI_CASES_INDEX_ALIAS = exports.CAI_CASES_BACKFILL_TASK_ID = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_CASES_INDEX_NAME = exports.CAI_CASES_INDEX_NAME = '.internal.cases';
const CAI_CASES_INDEX_ALIAS = exports.CAI_CASES_INDEX_ALIAS = '.cases';
const CAI_CASES_INDEX_VERSION = exports.CAI_CASES_INDEX_VERSION = 1;
const CAI_CASES_SOURCE_QUERY = exports.CAI_CASES_SOURCE_QUERY = {
  term: {
    type: 'cases'
  }
};
const CAI_CASES_SOURCE_INDEX = exports.CAI_CASES_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_CASES_BACKFILL_TASK_ID = exports.CAI_CASES_BACKFILL_TASK_ID = 'cai_cases_backfill_task';
const CAI_CASES_SYNCHRONIZATION_TASK_ID = exports.CAI_CASES_SYNCHRONIZATION_TASK_ID = 'cai_cases_synchronization_task';
const getCasesSynchronizationSourceQuery = lastSyncAt => ({
  bool: {
    must: [{
      term: {
        type: 'cases'
      }
    }, {
      bool: {
        should: [{
          range: {
            'cases.created_at': {
              gte: lastSyncAt.toISOString()
            }
          }
        }, {
          range: {
            'cases.updated_at': {
              gte: lastSyncAt.toISOString()
            }
          }
        }]
      }
    }]
  }
});
exports.getCasesSynchronizationSourceQuery = getCasesSynchronizationSourceQuery;