"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("../translations"));
var _form = require("../form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateCaseFlyout = exports.CreateCaseFlyout = /*#__PURE__*/_react.default.memo(({
  afterCaseCreated,
  attachments,
  headerContent,
  initialValue,
  onClose,
  onSuccess
}) => {
  const handleCancel = onClose || _lodash.noop;
  const handleOnSuccess = onSuccess || _lodash.noop;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleCancel,
    "tour-step": "create-case-flyout",
    "data-test-subj": "create-case-flyout"
    // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
    ,
    maskProps: {
      style: `z-index: ${euiTheme.levels.flyout + 3}`
    } // we need this flyout to be above the timeline flyout (which has a z-index of 1002)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    "data-test-subj": "create-case-flyout-header",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.CREATE_CASE_TITLE)), headerContent && headerContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
              && .euiFlyoutBody__overflow {
                overflow-y: auto;
                overflow-x: hidden;
              }

              && .euiFlyoutBody__overflowContent {
                display: block;
                padding: ${euiTheme.size.l} ${euiTheme.size.l} ${euiTheme.size.xxxxl};
                height: auto;
              }
            `
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                width: 100%;
              `
  }, /*#__PURE__*/_react.default.createElement(_form.CreateCaseForm, {
    afterCaseCreated: afterCaseCreated,
    attachments: attachments,
    onCancel: handleCancel,
    onSuccess: handleOnSuccess,
    withSteps: false,
    initialValue: initialValue
  })))));
});
CreateCaseFlyout.displayName = 'CreateCaseFlyout';