"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilterComponent = exports.StatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _domain = require("../../../common/types/domain");
var _multi_select_filter = require("./multi_select_filter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const caseStatuses = [{
  key: _domain.CaseStatuses.open,
  label: i18n.STATUS_OPEN
}, {
  key: _domain.CaseStatuses['in-progress'],
  label: i18n.STATUS_IN_PROGRESS
}, {
  key: _domain.CaseStatuses.closed,
  label: i18n.STATUS_CLOSED
}];
const StatusFilterComponent = ({
  countClosedCases,
  countInProgressCases,
  countOpenCases,
  hiddenStatuses = [],
  onChange,
  selectedOptionKeys
}) => {
  const stats = (0, _react.useMemo)(() => ({
    [_domain.CaseStatuses.open]: countOpenCases !== null && countOpenCases !== void 0 ? countOpenCases : 0,
    [_domain.CaseStatuses['in-progress']]: countInProgressCases !== null && countInProgressCases !== void 0 ? countInProgressCases : 0,
    [_domain.CaseStatuses.closed]: countClosedCases !== null && countClosedCases !== void 0 ? countClosedCases : 0
  }), [countClosedCases, countInProgressCases, countOpenCases]);
  const options = (0, _react.useMemo)(() => [...caseStatuses].filter(status => !hiddenStatuses.includes(status.key)), [hiddenStatuses]);
  const renderOption = option => {
    const selectedStatus = option.key;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: 'center',
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_status.Status, {
      status: selectedStatus
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, ` (${stats[selectedStatus]})`));
  };
  return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: i18n.STATUS,
    id: 'status',
    onChange: onChange,
    options: options,
    renderOption: renderOption,
    selectedOptionKeys: selectedOptionKeys,
    isLoading: false
  });
};
exports.StatusFilterComponent = StatusFilterComponent;
StatusFilterComponent.displayName = 'StatusFilterComponent';
const StatusFilter = exports.StatusFilter = /*#__PURE__*/_react.default.memo(StatusFilterComponent);