"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFreshStore = createFreshStore;
exports.createStore = createStore;
exports.destroyStore = destroyStore;
var _store = require("./state/store");
var _initial_state = require("./state/initial_state");
var _constants = require("../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

async function createStore(core) {
  if ((0, _store.getStore)()) {
    return (0, _store.cloneStore)();
  }
  return createFreshStore(core);
}
async function createFreshStore(core) {
  const initialState = (0, _initial_state.getInitialState)();
  const basePath = core.http.basePath.get();

  // Retrieve server functions
  const serverFunctionsResponse = await core.http.get(_constants.API_ROUTE_FUNCTIONS, {
    version: '1'
  });
  const serverFunctions = Object.values(serverFunctionsResponse);
  initialState.app = {
    basePath,
    serverFunctions,
    ready: false
  };
  return (0, _store.createStore)(initialState);
}
function destroyStore() {
  (0, _store.destroyStore)();
}