"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getSaveGroupDescription: () => _i18n.i18n.translate('xpack.canvas.groupSettings.saveGroupDescription', {
    defaultMessage: 'Save this group as a new element to re-use it throughout your workpad.'
  }),
  getUngroupDescription: () => _i18n.i18n.translate('xpack.canvas.groupSettings.ungroupDescription', {
    defaultMessage: 'Ungroup ({uKey}) to edit individual element settings.',
    values: {
      uKey: 'U'
    }
  })
};
const GroupSettings = () => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasSidebar__panel canvasSidebar__panel--isEmpty"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, strings.getUngroupDescription()), /*#__PURE__*/_react.default.createElement("p", null, strings.getSaveGroupDescription())));
exports.GroupSettings = GroupSettings;