"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _reactRedux = require("react-redux");
var _workpad = require("../../../state/selectors/workpad");
var _element_settings = require("./element_settings.component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElementSettings = ({
  selectedElementId
}) => {
  const element = (0, _reactRedux.useSelector)(state => {
    return (0, _workpad.getElementById)(state, selectedElementId, (0, _workpad.getSelectedPage)(state));
  }, _reactFastCompare.default);
  if (element) {
    return /*#__PURE__*/_react.default.createElement(_element_settings.ElementSettings, {
      element: element
    });
  }
  return null;
};
exports.ElementSettings = ElementSettings;