"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionFormList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _function_form = require("../function_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FunctionFormList = ({
  functionFormItems
}) => {
  const argTypeComponents = functionFormItems.map(functionFormProps => {
    return /*#__PURE__*/_react.default.createElement(_function_form.FunctionForm, (0, _extends2.default)({}, functionFormProps, {
      key: `${functionFormProps.argType}-${functionFormProps.expressionIndex}`
    }));
  });
  return /*#__PURE__*/_react.default.createElement("div", null, argTypeComponents);
};
exports.FunctionFormList = FunctionFormList;
FunctionFormList.propTypes = {
  functionFormItems: _propTypes.default.array.isRequired
};