"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmEventClient = getApmEventClient;
var _common = require("@kbn/data-plugin/common");
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
var _create_apm_event_client = require("./create_es_client/create_apm_event_client");
var _with_apm_span = require("../../utils/with_apm_span");
var _register_apm_server_routes = require("../../routes/apm_routes/register_apm_server_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmEventClient({
  context,
  params,
  getApmIndices,
  request
}) {
  return (0, _with_apm_span.withApmSpan)('get_apm_event_client', async () => {
    const coreContext = await context.core;
    const [indices, uiSettings] = await Promise.all([getApmIndices(), (0, _with_apm_span.withApmSpan)('get_ui_settings', async () => {
      const includeFrozen = await coreContext.uiSettings.client.get(_common.UI_SETTINGS.SEARCH_INCLUDE_FROZEN);
      const excludedDataTiers = await coreContext.uiSettings.client.get(_ui_settings_keys.searchExcludedDataTiers);
      return {
        includeFrozen,
        excludedDataTiers
      };
    })]);
    return new _create_apm_event_client.APMEventClient({
      esClient: coreContext.elasticsearch.client.asCurrentUser,
      debug: params.query._inspect,
      request,
      indices,
      options: {
        includeFrozen: uiSettings.includeFrozen,
        excludedDataTiers: uiSettings.excludedDataTiers,
        inspectableEsQueriesMap: _register_apm_server_routes.inspectableEsQueriesMap
      }
    });
  });
}