"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmDataViewIndexPattern = getApmDataViewIndexPattern;
exports.useAdHocApmDataView = useAdHocApmDataView;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmDataViewIndexPattern() {
  return (0, _create_call_apm_api.callApmApi)('GET /internal/apm/data_view/index_pattern', {
    signal: null
  });
}
function useAdHocApmDataView() {
  const {
    services,
    notifications
  } = (0, _public.useKibana)();
  const [dataView, setDataView] = (0, _react.useState)();
  const [apmIndices, setApmIndices] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function fetchDataView() {
      const {
        apmDataViewIndexPattern,
        apmIndices: indices
      } = await getApmDataViewIndexPattern();
      try {
        const displayError = false;
        const adHocDataView = await services.dataViews.create({
          title: apmDataViewIndexPattern,
          timeFieldName: '@timestamp'
        }, undefined, displayError);
        return {
          dataView: adHocDataView,
          apmIndices: indices
        };
      } catch (e) {
        const noDataScreen = e.message.includes('No matching indices found');
        if (noDataScreen) {
          return;
        }
        notifications.toasts.danger({
          title: _i18n.i18n.translate('xpack.apm.data_view.creation_failed', {
            defaultMessage: 'An error occurred while creating the data view'
          }),
          body: e.message
        });
        throw e;
      }
    }
    fetchDataView().then(result => {
      if (!result) {
        return;
      }
      setDataView(result.dataView);
      setApmIndices(result.apmIndices);
    });
  }, [notifications.toasts, services.dataViews]);
  return {
    dataView,
    apmIndices
  };
}