"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCountSummaryItemBadge = ErrorCountSummaryItemBadge;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_theme = require("../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorCountSummaryItemBadge({
  count
}) {
  const theme = (0, _use_theme.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: theme.eui.euiColorDanger,
    style: {
      maxWidth: '200px'
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.errorCount', {
    defaultMessage: '{errorCount, number} {errorCount, plural, one {Error} other {Errors}}',
    values: {
      errorCount: count
    }
  }));
}