"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PERSISTENT_APM_PARAMS = void 0;
exports.getLegacyApmHref = getLegacyApmHref;
exports.useAPMHref = useAPMHref;
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _url = _interopRequireDefault(require("url"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _pick_keys = require("../../../../../common/utils/pick_keys");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _url_helpers = require("../url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PERSISTENT_APM_PARAMS = exports.PERSISTENT_APM_PARAMS = ['kuery', 'rangeFrom', 'rangeTo', 'refreshPaused', 'refreshInterval', 'environment', 'serviceGroup', 'comparisonEnabled'];

/**
 * Hook to get a link for a path with persisted filters
 */
function useAPMHref({
  path,
  persistedFilters,
  query,
  pathParams
}) {
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    basePath
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.http;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const nextQuery = {
    ...(0, _pick_keys.pickKeys)(urlParams, ...(persistedFilters !== null && persistedFilters !== void 0 ? persistedFilters : [])),
    ...query
  };
  const encodedPath = (0, _typedReactRouterConfig.encodePath)(path, pathParams);
  return getLegacyApmHref({
    basePath,
    path: encodedPath,
    query: nextQuery,
    search
  });
}

/**
 * Get an APM link for a path.
 */
function getLegacyApmHref({
  basePath,
  path = '',
  search,
  query = {}
}) {
  const currentQuery = (0, _url_helpers.toQuery)(search);
  const nextQuery = {
    ...(0, _lodash.pick)(currentQuery, PERSISTENT_APM_PARAMS),
    ...query
  };
  const nextSearch = (0, _url_helpers.fromQuery)(nextQuery);
  return _url.default.format({
    pathname: basePath.prepend(`/app/apm${path}`),
    search: nextSearch
  });
}