"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BetaBadge = BetaBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BetaBadge({
  icon
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.apm.betaBadgeLabel', {
      defaultMessage: 'Beta'
    }),
    title: _i18n.i18n.translate('xpack.apm.betaBadgeLabel', {
      defaultMessage: 'Beta'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.apm.betaBadgeDescription', {
      defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, please open an issue or visit our discussion forum.'
    }),
    iconType: icon
  });
}