"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmAgents = ApmAgents;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_instructions_accordion = require("./agent_instructions_accordion");
var _agent_instructions_mappings = require("./agent_instructions_mappings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmAgents({
  newPolicy
}) {
  var _newPolicy$inputs, _newPolicy$inputs$;
  const vars = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$ = _newPolicy$inputs[0]) === null || _newPolicy$inputs$ === void 0 ? void 0 : _newPolicy$inputs$.vars;
  const apmServerUrl = vars === null || vars === void 0 ? void 0 : vars.url.value;
  const secretToken = vars === null || vars === void 0 ? void 0 : vars.secret_token.value;
  return /*#__PURE__*/_react.default.createElement("div", null, _agent_instructions_mappings.ApmAgentInstructionsMappings.map(({
    agentName,
    title,
    createAgentInstructions,
    variantId
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `${agentName}-${variantId}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_agent_instructions_accordion.AgentInstructionsAccordion, {
    agentName: agentName,
    title: title,
    createAgentInstructions: createAgentInstructions,
    variantId: variantId,
    apmServerUrl: apmServerUrl,
    secretToken: secretToken
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
}