"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceMap = ServiceMap;
exports.ServiceMapHome = ServiceMapHome;
exports.ServiceMapServiceDetail = ServiceMapServiceDetail;
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _rxjs = require("rxjs");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _license_check = require("../../../../common/license_check");
var _service_map = require("../../../../common/service_map");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_license_context = require("../../../context/license/use_license_context");
var _use_theme = require("../../../hooks/use_theme");
var _license_prompt = require("../../shared/license_prompt");
var _controls = require("./controls");
var _cytoscape = require("./cytoscape");
var _cytoscape_options = require("./cytoscape_options");
var _empty_banner = require("./empty_banner");
var _empty_prompt = require("./empty_prompt");
var _popover = require("./popover");
var _timeout_prompt = require("./timeout_prompt");
var _use_ref_dimensions = require("./use_ref_dimensions");
var _search_bar = require("../../shared/search_bar/search_bar");
var _use_service_name = require("../../../hooks/use_service_name");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _disabled_prompt = require("./disabled_prompt");
var _use_service_map = require("./use_service_map");
var _try_it_button = require("../../shared/try_it_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PromptContainer({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround"
    // Set the height to give it some top margin
    ,
    style: {
      height: '60vh'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 600,
      textAlign: 'center'
    }
  }, children)));
}
function LoadingSpinner() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    style: {
      position: 'absolute',
      top: '50%',
      left: '50%'
    }
  });
}
function ServiceMapHome() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      serviceGroup
    }
  } = (0, _use_apm_params.useApmParams)('/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(ServiceMap, {
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    serviceGroupId: serviceGroup
  });
}
function ServiceMapServiceDetail() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(ServiceMap, {
    environment: environment,
    kuery: kuery,
    start: start,
    end: end
  });
}
function ServiceMap({
  environment,
  kuery,
  start,
  end,
  serviceGroupId
}) {
  var _settingsField$savedV, _error$body, _error$body2;
  const theme = (0, _use_theme.useTheme)();
  const license = (0, _use_license_context.useLicenseContext)();
  const serviceName = (0, _use_service_name.useServiceName)();
  const {
    config,
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const subscriptions = (0, _react.useRef)(new _rxjs.Subscription());
  const [isServiceMapApiV2Enabled, setIsServiceMapApiV2Enabled] = (0, _react.useState)(core.settings.client.get(_common.apmEnableServiceMapApiV2));
  (0, _react.useEffect)(() => {
    subscriptions.current.add(core.settings.client.get$(_common.apmEnableServiceMapApiV2).subscribe(value => {
      setIsServiceMapApiV2Enabled(value);
    }));
  }, [core.settings]);
  (0, _react.useEffect)(() => {
    const currentSubscriptions = subscriptions.current;
    return () => {
      currentSubscriptions.unsubscribe();
    };
  }, []);
  const {
    fields,
    isSaving,
    saveSingleSetting
  } = (0, _public.useEditableSettings)([_common.apmEnableServiceMapApiV2]);
  const settingsField = fields[_common.apmEnableServiceMapApiV2];
  const isServiceMapV2Enabled = Boolean((_settingsField$savedV = settingsField === null || settingsField === void 0 ? void 0 : settingsField.savedValue) !== null && _settingsField$savedV !== void 0 ? _settingsField$savedV : settingsField === null || settingsField === void 0 ? void 0 : settingsField.defaultValue);
  const {
    data,
    status,
    error
  } = (0, _use_service_map.useServiceMap)({
    environment,
    kuery,
    start,
    end,
    serviceGroupId,
    serviceName,
    isServiceMapApiV2Enabled
  });
  const {
    ref,
    height
  } = (0, _use_ref_dimensions.useRefDimensions)();

  // Temporary hack to work around bottom padding introduced by EuiPage
  const PADDING_BOTTOM = 24;
  const heightWithPadding = height - PADDING_BOTTOM;
  if (!license) {
    return null;
  }
  if (!(0, _license_check.isActivePlatinumLicense)(license)) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      text: _service_map.invalidLicenseMessage
    }));
  }
  if (!config.serviceMapEnabled) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_disabled_prompt.DisabledPrompt, null));
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS && data.elements.length === 0) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null));
  }
  if (status === _use_fetcher.FETCH_STATUS.FAILURE && error && 'body' in error && ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 500 && ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) === _service_map.SERVICE_MAP_TIMEOUT_ERROR) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_timeout_prompt.TimeoutPrompt, {
      isGlobalServiceMap: !serviceName
    }));
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    onPageReady({
      customMetrics: {
        key1: 'num_of_nodes',
        value1: data.nodesCount,
        key2: 'num_of_traces',
        value2: data.tracesCount
      },
      meta: {
        rangeFrom: start,
        rangeTo: end
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_try_it_button.TryItButton, {
    isFeatureEnabled: isServiceMapV2Enabled,
    linkLabel: isServiceMapV2Enabled ? _i18n.i18n.translate('xpack.apm.serviceMap.disableServiceMapApiV2', {
      defaultMessage: 'Disable the new service map API'
    }) : _i18n.i18n.translate('xpack.apm.serviceMap.enableServiceMapApiV2', {
      defaultMessage: 'Enable the new service map API'
    }),
    onClick: () => {
      saveSingleSetting(_common.apmEnableServiceMapApiV2, !isServiceMapV2Enabled);
    },
    isLoading: isSaving,
    popoverContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.apm.serviceMap.serviceMapApiV2PopoverContent', {
      defaultMessage: 'The new service map API is faster, try it out!'
    }))),
    hideThisContent: _i18n.i18n.translate('xpack.apm.serviceMap.hideThisContent', {
      defaultMessage: 'Hide this. The setting can be enabled or disabled in Advanced Settings.'
    }),
    calloutId: "showServiceMapV2Callout"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "serviceMap",
    style: {
      height: heightWithPadding
    },
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_cytoscape.Cytoscape, {
    elements: data.elements,
    height: heightWithPadding,
    serviceName: serviceName,
    style: (0, _cytoscape_options.getCytoscapeDivStyle)(theme, status)
  }, /*#__PURE__*/_react.default.createElement(_controls.Controls, null), serviceName && /*#__PURE__*/_react.default.createElement(_empty_banner.EmptyBanner, null), status === _use_fetcher.FETCH_STATUS.LOADING && /*#__PURE__*/_react.default.createElement(LoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    focusedServiceName: serviceName,
    environment: environment,
    kuery: kuery,
    start: start,
    end: end
  })))));
}