"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSavedDashboardToPanels = convertSavedDashboardToPanels;
exports.hasDashboard = hasDashboard;
var _mustache = _interopRequireDefault(require("mustache"));
var _dashboard_catalog = require("./dashboards/dashboard_catalog");
var _get_dashboard_file_name = require("./dashboards/get_dashboard_file_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDashboardFileNameFromProps({
  agentName,
  telemetrySdkName,
  telemetrySdkLanguage
}) {
  const dashboardFile = agentName && (0, _get_dashboard_file_name.getDashboardFileName)({
    agentName,
    telemetrySdkName,
    telemetrySdkLanguage
  });
  return dashboardFile;
}
function hasDashboard(props) {
  const dashboardFilename = getDashboardFileNameFromProps(props);
  return !!dashboardFilename && _dashboard_catalog.existingDashboardFileNames.has(dashboardFilename);
}
const getAdhocDataView = dataView => {
  return {
    [dataView.id]: {
      ...dataView
    }
  };
};
async function convertSavedDashboardToPanels(props, apmIndices) {
  var _apmIndices$metric;
  const {
    dataView
  } = props;
  const dashboardFilename = getDashboardFileNameFromProps(props);
  const unreplacedDashboardJSON = !!dashboardFilename ? await (0, _dashboard_catalog.loadDashboardFile)(dashboardFilename) : false;
  if (!dashboardFilename || !unreplacedDashboardJSON) {
    return undefined;
  }

  // Convert the Dashboard into a string
  const dashboardString = JSON.stringify(unreplacedDashboardJSON);
  // Replace indexPattern placeholder
  const dashboardStringWithReplacements = _mustache.default.render(dashboardString, {
    indexPattern: (_apmIndices$metric = apmIndices === null || apmIndices === void 0 ? void 0 : apmIndices.metric) !== null && _apmIndices$metric !== void 0 ? _apmIndices$metric : dataView.getIndexPattern()
  });
  // Convert to JSON object
  const dashboardJSON = JSON.parse(dashboardStringWithReplacements);
  const panelsRawObjects = JSON.parse(dashboardJSON.attributes.panelsJSON);
  const panels = panelsRawObjects.reduce((acc, panel) => {
    var _attributes$state$dat, _attributes$state, _ref, _datasourceStates$for, _datasourceStates$for2, _datasourceStates$tex, _attributes$state2;
    const {
      gridData,
      embeddableConfig,
      panelIndex,
      title
    } = panel;
    const {
      attributes
    } = embeddableConfig;
    const datasourceStates = (_attributes$state$dat = attributes === null || attributes === void 0 ? void 0 : (_attributes$state = attributes.state) === null || _attributes$state === void 0 ? void 0 : _attributes$state.datasourceStates) !== null && _attributes$state$dat !== void 0 ? _attributes$state$dat : {};
    const layers = (_ref = (_datasourceStates$for = (_datasourceStates$for2 = datasourceStates.formBased) === null || _datasourceStates$for2 === void 0 ? void 0 : _datasourceStates$for2.layers) !== null && _datasourceStates$for !== void 0 ? _datasourceStates$for : (_datasourceStates$tex = datasourceStates.textBased) === null || _datasourceStates$tex === void 0 ? void 0 : _datasourceStates$tex.layers) !== null && _ref !== void 0 ? _ref : [];
    acc.push({
      type: panel.type,
      gridData,
      panelIndex,
      panelConfig: {
        id: panelIndex,
        ...embeddableConfig,
        title,
        attributes: {
          ...attributes,
          references: [],
          state: {
            ...((_attributes$state2 = attributes === null || attributes === void 0 ? void 0 : attributes.state) !== null && _attributes$state2 !== void 0 ? _attributes$state2 : {}),
            adHocDataViews: getAdhocDataView(dataView),
            internalReferences: Object.keys(layers).map(layerId => ({
              id: dataView.id,
              name: `indexpattern-datasource-layer-${layerId}`,
              type: 'index-pattern'
            }))
          }
        }
      }
    });
    return acc;
  }, []);
  return panels;
}