"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGetMaintenanceWindowRoute = void 0;
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _common = require("../../../../../../common");
var _bulk_get = require("../../../../../../common/routes/maintenance_window/internal/apis/bulk_get");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkGetMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/_bulk_get`,
    validate: {
      body: _bulk_get.bulkGetBodySchemaV1
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const body = req.body;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const result = await maintenanceWindowClient.bulkGet({
      ids: body.ids
    });
    const response = {
      body: (0, _transforms.transformBulkGetResultToResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.bulkGetMaintenanceWindowRoute = bulkGetMaintenanceWindowRoute;