"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unmuteInstance = unmuteInstance;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _saved_objects = require("../../../../saved_objects");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _schemas = require("./schemas");
var _lib = require("../../../../rules_client/lib");
var _rule = require("../../../../data/rule");
var _authorization = require("../../../../authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function unmuteInstance(context, params) {
  const ruleId = params.alertId;
  try {
    _schemas.unmuteAlertParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Failed to validate params: ${error.message}`);
  }
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.unmuteInstance('${ruleId}')`, async () => await unmuteInstanceWithOCC(context, params));
}
async function unmuteInstanceWithOCC(context, {
  alertId: ruleId,
  alertInstanceId
}) {
  var _context$auditLogger2;
  const {
    attributes,
    version
  } = await context.unsecuredSavedObjectsClient.get(_saved_objects.RULE_SAVED_OBJECT_TYPE, ruleId);
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: attributes.alertTypeId,
      consumer: attributes.consumer,
      operation: _authorization.WriteOperations.UnmuteAlert,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    if (attributes.actions.length) {
      await context.actionsAuthorization.ensureAuthorized({
        operation: 'execute'
      });
    }
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.UNMUTE_ALERT,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id: ruleId,
        name: attributes.name
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.UNMUTE_ALERT,
    outcome: 'unknown',
    savedObject: {
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      id: ruleId,
      name: attributes.name
    }
  }));
  context.ruleTypeRegistry.ensureRuleTypeEnabled(attributes.alertTypeId);
  const mutedInstanceIds = attributes.mutedInstanceIds || [];
  if (!attributes.muteAll && mutedInstanceIds.includes(alertInstanceId)) {
    await (0, _rule.updateRuleSo)({
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      savedObjectsUpdateOptions: {
        version
      },
      id: ruleId,
      updateRuleAttributes: (0, _lib.updateMeta)(context, {
        mutedInstanceIds: mutedInstanceIds.filter(id => id !== alertInstanceId),
        updatedBy: await context.getUserName(),
        updatedAt: new Date().toISOString()
      })
    });
  }
}