"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findGaps = findGaps;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _authorization = require("../../../../authorization");
var _find_gaps = require("../../../../lib/rule_gaps/find_gaps");
var _get_rule = require("../get/get_rule");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _saved_objects = require("../../../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findGaps(context, params) {
  try {
    var _context$auditLogger2;
    const rule = await (0, _get_rule.getRule)(context, {
      id: params.ruleId,
      includeLegacyId: true
    });
    try {
      // Make sure user has access to this rule
      await context.authorization.ensureAuthorized({
        ruleTypeId: rule.alertTypeId,
        consumer: rule.consumer,
        operation: _authorization.ReadOperations.FindGaps,
        entity: _authorization.AlertingAuthorizationEntity.Rule
      });
    } catch (error) {
      var _context$auditLogger;
      (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
        action: _audit_events.RuleAuditAction.FIND_GAPS,
        savedObject: {
          type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
          id: rule.id,
          name: rule.name
        },
        error
      }));
      throw error;
    }
    const eventLogClient = await context.getEventLogClient();
    const gaps = await (0, _find_gaps.findGaps)({
      params,
      eventLogClient,
      logger: context.logger
    });
    (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.FIND_GAPS,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id: rule.id,
        name: rule.name
      }
    }));
    return gaps;
  } catch (err) {
    const errorMessage = `Failed to find gaps`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}