"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGetRules = bulkGetRules;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _pMap = _interopRequireDefault(require("p-map"));
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _saved_objects = require("../../../../saved_objects");
var _schemas = require("./schemas");
var _rule = require("../../../../data/rule");
var _transforms = require("../../transforms");
var _lib = require("../../../../lib");
var _lib2 = require("../../../../rules_client/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function bulkGetRules(context, params) {
  try {
    _schemas.bulkGetRulesParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating get rules params - ${error.message}`);
  }
  const kueryNodeFilter = (0, _lib.convertRuleIdsToKueryNode)(params.ids);
  const authorizationFilter = await (0, _lib2.getAuthorizationFilter)(context, {
    action: 'GET'
  });
  const kueryNodeFilterWithAuth = authorizationFilter && kueryNodeFilter ? _esQuery.nodeBuilder.and([kueryNodeFilter, authorizationFilter]) : kueryNodeFilter;
  await (0, _lib2.checkAuthorizationAndGetTotal)(context, {
    filter: kueryNodeFilterWithAuth,
    action: 'GET'
  });
  const result = {
    rules: [],
    errors: []
  };
  const savedObjects = [];
  await (0, _pMap.default)((0, _lodash.chunk)(params.ids, 100), async ids => {
    const {
      saved_objects
    } = await (0, _rule.bulkGetRulesSo)({
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      ids
    });
    saved_objects.forEach(so => {
      if (so.error) {
        result.errors.push({
          id: so.id,
          error: so.error
        });
        return;
      }
      savedObjects.push(so);
    });
  }, {
    concurrency: 10
  });
  savedObjects.forEach(rule => {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.GET,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id: rule.id,
        name: rule.attributes.name
      }
    }));
  });
  result.errors.forEach(({
    error,
    id
  }) => {
    var _context$auditLogger2;
    (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.GET,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id
      },
      error: new Error(error.message)
    }));
  });
  const paramsForTransform = (0, _lodash.omit)(params, ['ids']);
  const transformedRules = await (0, _pMap.default)(savedObjects, rule => (0, _transforms.transformRuleSoToSanitizedRule)(context, rule, paramsForTransform), {
    concurrency: 10
  });
  result.rules.push(...transformedRules);
  return result;
}