"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateIndexTemplateFieldsLimit = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateIndexTemplateFieldsLimit = ({
  esClient,
  template,
  limit
}) => {
  var _template$index_templ;
  return esClient.indices.putIndexTemplate({
    name: template.name,
    body: {
      ...template.index_template,
      template: {
        ...template.index_template.template,
        settings: {
          ...((_template$index_templ = template.index_template.template) === null || _template$index_templ === void 0 ? void 0 : _template$index_templ.settings),
          'index.mapping.total_fields.limit': limit,
          'index.mapping.total_fields.ignore_dynamic_beyond_limit': true
        }
      },
      // GET brings string | string[] | undefined but this PUT expects string[]
      ignore_missing_component_templates: template.index_template.ignore_missing_component_templates ? [template.index_template.ignore_missing_component_templates].flat() : undefined
    }
  });
};
exports.updateIndexTemplateFieldsLimit = updateIndexTemplateFieldsLimit;