"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.archiveMaintenanceWindow = archiveMaintenanceWindow;
var _common = require("../../../common");
var _transform_maintenance_window_response = require("./transform_maintenance_window_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function archiveMaintenanceWindow({
  http,
  maintenanceWindowId,
  archive
}) {
  const res = await http.post(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/maintenance_window/${encodeURIComponent(maintenanceWindowId)}/_archive`, {
    body: JSON.stringify({
      archive
    })
  });
  return (0, _transform_maintenance_window_response.transformMaintenanceWindowResponse)(res);
}