"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _format_category = require("../format_category");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRow = ({
  category,
  displayExamples = true
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cssExpandedRow = (0, _react2.css)({
    marginRight: euiTheme.size.xxl,
    width: '100%'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: cssExpandedRow
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(Section, {
    title: _i18n.i18n.translate('xpack.aiops.logCategorization.expandedRow.title.tokens', {
      defaultMessage: 'Tokens'
    })
  }, /*#__PURE__*/_react.default.createElement(_format_category.FormattedTokens, {
    category: category
  })), /*#__PURE__*/_react.default.createElement(Section, {
    title: _i18n.i18n.translate('xpack.aiops.logCategorization.expandedRow.title.regex', {
      defaultMessage: 'Regex'
    })
  }, /*#__PURE__*/_react.default.createElement(_format_category.FormattedRegex, {
    category: category
  })), displayExamples ? /*#__PURE__*/_react.default.createElement(Section, {
    title: _i18n.i18n.translate('xpack.aiops.logCategorization.expandedRow.title.examples', {
      defaultMessage: 'Examples'
    })
  }, /*#__PURE__*/_react.default.createElement(_format_category.FormattedPatternExamples, {
    category: category
  })) : null);
};
exports.ExpandedRow = ExpandedRow;
const Section = ({
  title,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};