"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataFoundWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoDataFoundWarning = props => {
  var _props$onRenderComple;
  (_props$onRenderComple = props.onRenderComplete) === null || _props$onRenderComple === void 0 ? void 0 : _props$onRenderComple.call(props);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "aiopsNoDataFoundWarning",
    iconType: "search",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.changePointDetection.noDataFoundTitle",
      defaultMessage: "No data found"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.changePointDetection.noDataFoundMessage",
      defaultMessage: "No data found for the selected metric and time range. Try adjusting your selection to include data from your indices."
    }))
  });
};
exports.NoDataFoundWarning = NoDataFoundWarning;