"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsGridContainer = exports.ChartsGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _change_point_detection_context = require("./change_point_detection_context");
var _chart_component = require("./chart_component");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHARTS_PER_PAGE = 6;
/**
 * Shared component for change point charts grid.
 * Used both in AIOps UI and inside embeddable.
 *
 * @param changePoints
 * @constructor
 */
const ChartsGrid = ({
  changePoints,
  interval,
  onRenderComplete
}) => {
  // Render is complete when all chart components in the grid are ready
  const loadCounter = (0, _react.useRef)(Object.fromEntries(changePoints.map((v, i) => [i, true])));

  /**
   * Callback to track render of each chart component
   * to report when all charts are ready.
   */
  const onChartRenderCompleteCallback = (0, _react.useCallback)((chartId, isLoading) => {
    if (!onRenderComplete) return;
    loadCounter.current[chartId] = isLoading;
    const isLoadComplete = Object.values(loadCounter.current).every(v => !v);
    if (isLoadComplete) {
      onRenderComplete();
    }
  }, [onRenderComplete]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: changePoints.length >= 2 ? 2 : 1,
    responsive: true,
    gutterSize: 'm',
    css: {
      width: '100%'
    }
  }, changePoints.map((v, index) => {
    var _v$group$value, _v$group;
    const key = `${index}_${(_v$group$value = (_v$group = v.group) === null || _v$group === void 0 ? void 0 : _v$group.value) !== null && _v$group$value !== void 0 ? _v$group$value : 'single_metric'}_${v.fn}_${v.metricField}_${v.timestamp}_${v.p_value}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      hasBorder: true,
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'center',
      justifyContent: 'spaceBetween',
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, v.group ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "inline",
      listItems: [{
        title: v.group.name,
        description: v.group.value
      }]
    }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 's'
    }, v.fn, "(", v.metricField, ")"))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'spaceBetween',
      alignItems: 'center'
    }, v.p_value !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "inline",
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.aiops.changePointDetection.pValueLabel",
          defaultMessage: "p-value"
        }),
        description: v.p_value.toPrecision(3)
      }]
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, v.type))), /*#__PURE__*/_react.default.createElement(_chart_component.ChartComponent, {
      fieldConfig: {
        splitField: v.splitField,
        fn: v.fn,
        metricField: v.metricField
      },
      annotation: v,
      interval: interval,
      onLoading: isLoading => {
        if (isLoading) {
          onChartRenderCompleteCallback(index, true);
        }
      },
      onRenderComplete: () => {
        onChartRenderCompleteCallback(index, false);
      }
    })));
  }));
};

/**
 * Wrapper component for change point charts grid.
 *
 * @param changePointsDict
 * @constructor
 */
exports.ChartsGrid = ChartsGrid;
const ChartsGridContainer = ({
  changePoints: changePointsDict
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const initialRefreshSetting = (0, _react.useRef)();
  const {
    bucketInterval
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  (0, _react.useEffect)(function pauseRefreshOnMount() {
    initialRefreshSetting.current = timefilter.getRefreshInterval();
    timefilter.setRefreshInterval({
      ...initialRefreshSetting.current,
      pause: true
    });
    return () => {
      if (initialRefreshSetting.current) {
        // reset initial settings
        timefilter.setRefreshInterval(initialRefreshSetting.current);
      }
    };
  }, [timefilter]);
  const changePoints = (0, _react.useMemo)(() => {
    return Object.values(changePointsDict).flat();
  }, [changePointsDict]);
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const resultPerPage = (0, _react.useMemo)(() => {
    const start = activePage * CHARTS_PER_PAGE;
    return changePoints.slice(start, start + CHARTS_PER_PAGE);
  }, [changePoints, activePage]);
  const pagination = (0, _react.useMemo)(() => {
    var _changePoints$length;
    return {
      activePage,
      pageCount: Math.ceil(((_changePoints$length = changePoints.length) !== null && _changePoints$length !== void 0 ? _changePoints$length : 0) / CHARTS_PER_PAGE),
      updatePagination: setActivePage
    };
  }, [activePage, changePoints.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ChartsGrid, {
    changePoints: resultPerPage,
    interval: bucketInterval.expression
  }), pagination.pageCount > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: pagination.pageCount,
    activePage: pagination.activePage,
    onPageClick: pagination.updatePagination
  }))) : null);
};
exports.ChartsGridContainer = ChartsGridContainer;